import { Component } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Platform, Events } from '@ionic/angular';
import { SplashScreen } from '@ionic-native/splash-screen/ngx';
import { StatusBar } from '@ionic-native/status-bar/ngx';

import {
  AngularFirestore,
  AngularFirestoreDocument,
  AngularFirestoreCollection
} from '@angular/fire/firestore';
import * as firebase from 'firebase';
import { ModalController } from '@ionic/angular';
import { DeliverypopPage } from './deliverypop/deliverypop.page';
import { AuthService } from './../config/auth.service';
import { ServiceService } from './../config/service.service';
import { SubjectService } from './../config/subject.service';
import { CategoriesService } from './../config/category.service';
import { SearchmodalPage } from './searchmodal/searchmodal.page';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { NavigationBar } from '@ionic-native/navigation-bar/ngx';
@Component({
  selector: 'app-root',
  templateUrl: 'app.component.html',
  styleUrls: ['app.component.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({ transform: 'translateY(100%)' }),
        animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
      ]),
      transition(':leave', [
        animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
      ])
    ])
  ]
})
export class AppComponent {
  isSearchOpen = false;

  sec_active1 = true;
  sec_active2 = false;
  sec_active3 = false;
  sec_active4 = false;
  sec_active5 = false;
  sec_active6 = false;
  state: boolean;
  menuw: number;
  userData: any;
  tabData = true;

  isShow = false;
  orderId: any;

  constructor(
    private platform: Platform,
    private splashScreen: SplashScreen,
    private statusBar: StatusBar,
    private router: Router,
    public afs: AngularFirestore,
    public modalController: ModalController,
    public authService: AuthService,
    public service: ServiceService,
    public categoryService: CategoriesService,
    public subjectService: SubjectService,
    private route: ActivatedRoute,
    private navigationBar: NavigationBar,
    private location: Location,
    private events: Events
  ) {
    this.state = true;
    this.initializeApp();
    this.subjectService.getLoginData().subscribe(loginData => {
      this.state = loginData;
    });

    this.subjectService.getUserData().subscribe(userData => {
      if (userData) {
        this.userData = JSON.parse(userData);
        console.log(userData);
        this.orderState();
      } else {
        console.log(userData);
      }
    });

    this.subjectService.getTabData().subscribe(tabData => {
      console.log(tabData);
      if (tabData !== null) {
        this.tabData = tabData;
        console.log(this.tabData);
      }
    });
  }

  ionViewWillEnter() {
  }

  initializeApp() {
    this.platform.ready().then(() => {
      const autoHide = true;
      this.navigationBar.setUp(autoHide);
      this.statusBar.styleDefault();
      this.statusBar.hide();
      this.statusBar.overlaysWebView(false);
      this.statusBar.backgroundColorByHexString('#29285b');
    });
  }

  async finishpop(data: any) {
    const modal = await this.modalController.create({
      component: DeliverypopPage,
      componentProps: data
    });
    return await modal.present();
  }

  fetchCase() {
    const restrictedUrl = [
      '',
      'productdetail',
      'cart',
      'nearby',
      'verification',
      'orderplaced',
      'landing',
      'login',
      'signup',
      'address',
      'forgot',
      'feedback',
      'wishlist',
      'preference',
      'changedetails',
      'trackorder',
      'changeaddress',
      'changedetails',
      'contact',
      'myorder',
      'review'
    ];
    const currentUrl = this.router.url.split('/');
    if (currentUrl[1] === 'home') {
      this.setActive1();
    }
    if (currentUrl[1] === 'catagory') {
      this.setActive2();
    }
    if (currentUrl[1] === 'searchmodal') {
      this.setActive3();
    }
    if (currentUrl[1] === 'cart') {
      this.setActive4();
    }
    if (currentUrl[1] === 'cart') {
      this.setActive4();
    }
    if (currentUrl[1] === 'myorder') {
      this.setActive5();
    }
    if (currentUrl[1] === 'profile') {
      this.setActive6();
    }
    const index = restrictedUrl.findIndex(x => x === currentUrl[1]);
    if (index > -1 || this.tabData === false) {
      return true;
    } else {
      return false;
    }
  }

  goToPage(path, data = null) {
    if (data !== null) {
      this.service.set('catParams', data);
    }
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  setActive1() {
    this.sec_active1 = true;
    this.sec_active2 = false;
    this.sec_active3 = false;
    this.sec_active4 = false;
    this.sec_active5 = false;
    this.sec_active6 = false;
  }
  setActive2() {
    this.sec_active2 = true;
    this.sec_active1 = false;
    this.sec_active3 = false;
    this.sec_active4 = false;
    this.sec_active5 = false;
    this.sec_active6 = false;
  }
  setActive3() {
    this.sec_active3 = true;
    this.sec_active1 = false;
    this.sec_active2 = false;
    this.sec_active4 = false;
    this.sec_active5 = false;
    this.sec_active6 = false;
  }
  setActive4() {
    this.sec_active4 = true;
    this.sec_active1 = false;
    this.sec_active2 = false;
    this.sec_active3 = false;
    this.sec_active5 = false;
    this.sec_active6 = false;
  }
  setActive5() {
    this.sec_active5 = true;
    this.sec_active1 = false;
    this.sec_active2 = false;
    this.sec_active3 = false;
    this.sec_active4 = false;
    this.sec_active6 = false;
  }
  setActive6() {
    this.sec_active6 = true;
    this.sec_active1 = false;
    this.sec_active2 = false;
    this.sec_active3 = false;
    this.sec_active4 = false;
    this.sec_active5 = false;
  }

  orderState() {
    const custId = this.userData.uid;
    firebase
      .firestore()
      .collection('orders')
      .where('custId', '==', custId)
      .onSnapshot(snapData => {
        snapData.docChanges().forEach(change => {
          if (change.type === 'modified') {
            const data = change.doc.data();
            if (data.orderStatus === 7) {
              this.finishpop(data);
            } else {
              //if (data.orderStatus !== 1) {
              this.orderId = data.orderCode;
              this.isShow = true;
              setTimeout(() => {
                this.isShow = false;
              }, 3000);
              //} 
            }
          }
        });
      });

    /*



    .onSnapshot(function(snapshot) {
        snapshot.docChanges().forEach(function(change) {
            if (change.type === "added") {
                console.log("New city: ", change.doc.data());
            }
            if (change.type === "modified") {
                console.log("Modified city: ", change.doc.data());
            }
            if (change.type === "removed") {
                console.log("Removed city: ", change.doc.data());
            }
        });
    }); */
  }

  vieworder(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  async searchModal() {
    // Hides Bottom navbar items
    this.isSearchOpen = true;
    const modal = await this.modalController.create({
      component: SearchmodalPage
    });
    // modal.onDidDismiss().then(dataReturned => {
    //
    // });

    // Shows bottom navbar items on component unmount
    modal.onWillDismiss().then(() => {
      this.isSearchOpen = false;
    });
    return await modal.present();
  }

  istoggle() {
    this.isShow = !this.isShow;
  }
}
