import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { ContactData } from 'src/config/services/contact';
import { SubjectService } from '../../config/subject.service';
import { NgForm } from '@angular/forms';
import { ContactService } from 'src/config/contact.service';
import { ServiceService } from '../../config/service.service';
import { CallNumber } from '@ionic-native/call-number/ngx';
@Component({
  selector: 'app-contact',
  templateUrl: './contact.page.html',
  styleUrls: ['./contact.page.scss']
})
export class ContactPage implements OnInit {
  submitted = false;
  userData: any;
  contactData: ContactData = {
    from: '',
    message: '',
    contactId: ''
  };
  constructor(
    private location: Location,
    public subjectService: SubjectService,
    public contactService: ContactService,
    public service: ServiceService,
    private callNumber: CallNumber
  ) {
    // Gets userdata
    this.subjectService.getUserData().subscribe(userData => {
      if (userData) {
        this.userData = JSON.parse(userData);
        this.contactData.from = JSON.parse(userData).emailId;
        console.log(userData);
      } else {
        console.log(userData);
      }
    });
  }

  ngOnInit() { }

  callUs() {
    this.callNumber
      .callNumber('+61411622880', true)
      .then(res => console.log('Launched dialer!', res))
      .catch(err => console.log('Error launching dialer', err));
  }

  onContactSubmit(form: NgForm) {
    this.submitted = true;
    console.log(form.value);
    if (form.valid && form.value.message !== '') {
      this.service.get('orderId').then((orderId) => {
        const newOrder = orderId;
        const contData = { ...this.contactData, from: this.userData.emailId, orderId: newOrder };
        this.contactService.contactCreate(contData);
      });

    } else {
      console.log('form not valid');
      this.submitted = false;
      this.service.showToast('Invalid request!', 'top', 'my-error', 1000);
    }
  }

  goBack() {
    this.location.back();
  }
}

// +61 411 622 880
