import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { SubjectService } from '../../config/subject.service';
import { NgForm } from '@angular/forms';
import { FeedbackData } from '../../config/services/feedback';
import { FeedbackService } from '../../config/feedback.service';
import { ServiceService } from '../../config/service.service';
@Component({
  selector: 'app-feedback',
  templateUrl: './feedback.page.html',
  styleUrls: ['./feedback.page.scss']
})
export class FeedbackPage implements OnInit {
  submitted = false;
  userData: any;
  feedbackData: FeedbackData = {
    feedbackId: '',
    from: '',
    to: 'care@getmi.com',
    message: ''
  };

  constructor(
    private location: Location,
    public subjectService: SubjectService,
    public feedService: FeedbackService,
    public service: ServiceService
  ) {
    // Gets userdata
    this.subjectService.getUserData().subscribe(userData => {
      if (userData) {
        this.userData = JSON.parse(userData);
        console.log(userData);
      } else {
        console.log(userData);
      }
    });
  }

  onFeedbackSubmit(form: NgForm) {
    this.submitted = true;
    console.log(form.value);
    if (form.valid && form.value.message !== '') {
      this.feedService.feedbackCreate(form.value);
    } else {
      this.submitted = false;
      this.service.showToast('Invalid request!', 'top', 'my-error', 1000);
    }
  }

  ngOnInit() {}

  goBack() {
    this.location.back();
  }
}
