import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { ServiceService } from './../../config/service.service';

@Component({
  selector: 'app-ordercancelled',
  templateUrl: './ordercancelled.page.html',
  styleUrls: ['./ordercancelled.page.scss']
})
export class OrdercancelledPage implements OnInit {
  data: any;
  orderCancelled = new Date();
  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    private service: ServiceService
  ) {
    this.service.get('order').then(val => {
      this.data = val;
    });
  }

  ngOnInit() {}

  relatedProd = {
    slidesPerView: 2
  };

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }
}
