import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router, ActivatedRoute, NavigationExtras } from '@angular/router';
import { ProductsService } from './../../config/products.service';
import { ServiceService } from './../../config/service.service';
import { SearchService } from './../../config/search.service';
import { ModalController } from '@ionic/angular';
import { SearchmodalPage } from '../searchmodal/searchmodal.page';
import { SubjectService } from './../../config/subject.service';

@Component({
  selector: 'app-productlist',
  templateUrl: './productlist.page.html',
  styleUrls: ['./productlist.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({ transform: 'translateY(100%)' }),
        animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
      ]),
      transition(':leave', [
        animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
      ])
    ])
  ]
})
export class ProductlistPage implements OnInit {
  onGrid = false;
  isShow = false;
  data: any;
  searchShow = false;
  sortValue: string;
  loader: boolean;
  shopperId: any;
  custId: any;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    public prodService: ProductsService,
    public service: ServiceService,
    public searchService: SearchService,
    private modalController: ModalController,
    private subjectService: SubjectService
  ) {
    this.loader = true;
    const users = this.service.get('userData').then(data => {
      if (data) {
        data = JSON.parse(data);
        this.custId = data.uid;
      }
    });
  }

  ngOnInit() { }

  ionViewWillEnter() {
    console.log('logged');
    this.service.get('shopParams').then(val => {
      if (val) {
        this.data = val;
        this.shopperId = this.data.uid;
        console.log(this.data);
        this.prodService.prodList(this.data.uid);
        setTimeout(() => {
          this.loader = false;
        }, 2000);
      } else {
        this.goToPage('home');
      }
    });
    const users = this.service.get('user').then(data => {
      console.log(data);
      if (data) {
        data = JSON.parse(data);
        this.custId = data.uid;
        this.prodService.getFavlist(data.uid);
      }
    });
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  istoggle() {
    this.isShow = !this.isShow;
  }

  goBack() {
    // this.location.back();
    window.history.back();
  }

  unEscape(text: string) {
    const regex = '%uFFFD';
    return unescape(text.replace(/%uFFFD/g, ''));
  }

  gridToggle() {
    this.onGrid = !this.onGrid;
  }

  async clickSearch() {
    this.subjectService.setTabData(false);
    const modal = await this.modalController.create({
      component: SearchmodalPage
    });
    modal.onDidDismiss().then(dataReturned => {
      this.subjectService.setTabData(true);
    });
    return await modal.present();
  }

  searchClose() {
    this.searchShow = false;
  }

  prodDetails(index: number) {
    this.prodService.setProd(this.prodService.product[index]);
    this.router.navigateByUrl('productdetail');
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  changeFav(index) {
    const state = this.prodService.fav.findIndex(x => x === index);
    console.log(state);
    console.log(this.prodService.fav);
    if (state > -1) {
      this.prodService.fav.splice(state, 1);
      this.prodService.changeFav(index, 'yes', this.custId);
    } else {
      this.prodService.fav.push(index);
      this.prodService.changeFav(index, 'no', this.custId);
    }
    return;
    console.log(this.prodService.fav);
  }

  setValue(value) {
    this.sortValue = value;
    console.log(this.sortValue);
  }

  submit() {
    console.log(this.sortValue);
    this.prodService.filterSearch(this.sortValue, this.shopperId);
  }

  checkFavStatus(index) {
    const state = this.prodService.fav.findIndex(x => x === index);
    return state > -1 ? 'fav_fill' : 'fav_icon';
  }

  searchFun(data: string) {
    this.searchService.search(data);
  }

  viewPage(datas: any) {
    console.log(datas);
    let data;
    let url;
    if (datas.type === 'shopper') {
      data = datas.data;
      this.service.set('shopParams', data);
      url = 'productlist';
    } else if (datas.type === 'category') {
      data = datas.data;
      this.service.set('catParams', data);
      url = 'catstorelist';
    } else {
      data = datas.data;
      data.size = this.service.splitSep(data.size);
      data.tag = this.service.splitSep(data.tag);
      (data.color = this.service.splitSep(data.color)), (url = 'productdetail');
      this.prodService.setProd(data);
    }
    this.searchClose();
    this.router.navigateByUrl(url, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
}
