
import { Component, OnInit, ViewChild, ElementRef } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { MyordersService } from './../../config/myorder.service';
import { Myorder } from './../../config/services/myorder';

declare var google;

@Component({
  selector: 'app-trackorder',
  templateUrl: './trackorder.page.html',
  styleUrls: ['./trackorder.page.scss'],
})
export class TrackorderPage implements OnInit {

  map: any;
  address: string;
  order: Myorder;

  public lat: number = 51.678418;
  public lng: number = 7.809007;
  public origin: any;
  public destination: any;
  public renderOptions: any;
  public markerOptions: any;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    public myorder: MyordersService
  ) { }


  ngOnInit() {
    this.getDirection();
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    window.history.back();
  }




  getDirection() {
    this.order = this.myorder.selItem;
    this.origin = { lat: this.order.pickupLocation.latitude, lng: this.order.pickupLocation.longitude };
    this.destination = { lat: this.order.deliveryLocation.latitude, lng: this.order.deliveryLocation.longitude };
    this.renderOptions = { polylineOptions: { strokeColor: 'rgba(69, 67, 152,1)' }, suppressMarkers: true };
    this.markerOptions = {
      origin: {
        icon: './assets/source.png',
      },
      destination: {
        icon: './assets/destination.png',
      }
    };
  }

}
