import { Injectable } from '@angular/core';
import {
  AngularFirestore,
  AngularFirestoreCollection
} from '@angular/fire/firestore';
import { take } from 'rxjs/operators';
import { FeedbackData } from './services/feedback';
import { ServiceService } from './service.service';
import { Router, ActivatedRoute } from '@angular/router';

@Injectable({
  providedIn: 'root'
})
export class FeedbackService {
  loader: boolean;
  constructor(
    public afs: AngularFirestore,
    private router: Router,
    private service: ServiceService
  ) {
    this.loader = false;
  }

  feedbackCreate(data: FeedbackData) {
    this.loader = true;
    this.afs
      .collection('feedback')
      .add({})
      .then(docRef => {
        data.feedbackId = docRef.id;
        this.afs
          .collection('feedback')
          .doc(data.feedbackId)
          .set(data)
          .then(() => {
            this.service
              .showToast(
                'Thank you for your feedback!',
                'top',
                'my-toast',
                2000
              )
              .then(() => {
                this.loader = false;
                setTimeout(() => {
                  this.router.navigateByUrl('home');
                }, 2100);
              })
              .catch(err => {
                this.loader = false;
              });
          });
      });
  }
}
