import { Injectable } from '@angular/core';
import { AngularFirestore, AngularFirestoreDocument, AngularFirestoreCollection } from '@angular/fire/firestore';
import { Router, ActivatedRoute } from '@angular/router';
import { Order, CartProd } from './services/order';
import { Products } from './services/product';
import { ServiceService } from './service.service';
import * as firebase from 'firebase';
import { CartItem } from './services/cart';
import { BehaviorSubject } from 'rxjs';


@Injectable({
  providedIn: 'root'
})
export class OrdersService {
  order: Order;
  size: string;
  color: string;
  custId: string;
  shopperId: any;
  checkout = new BehaviorSubject(false);
  users: any;

  constructor(
    public afs: AngularFirestore,
    public router: Router,
    public service: ServiceService
  ) {
    this.size = 'small';
    this.color = 'Blue';
    this.custId = '';
    this.service.get('user').then((data) => {
      if (data) {
        data = JSON.parse(data);
        this.users = data;
        this.custId = data.uid;
        console.log(this.custId);
      } else {
        this.custId = 'WwHnLICVY2dvZGUHuKqasiTB91a2';
      }
    });
  }

  /*public async orgcheckOut(cart: CartItem[]) {
    console.log(cart);
    console.log(this.users);
    return;
    let currProcess = 0;
    const cartCount = cart.length;
    cart.forEach((product) => {
      this.afs.collection('orders').add({
        bookDate: firebase.firestore.FieldValue.serverTimestamp()
      }).then((docRef) => {
        const neworderId = docRef.id;
        const delivery = new firebase.firestore.GeoPoint(10.0237, 76.3116);
        const pickup = new firebase.firestore.GeoPoint(10.7231, 76.1234);
        const orderItem: Order = {
          amount: 'A$ 175',
          customer: firebase.firestore().doc('/customer/' + this.custId),
          shopper: product.shopperId,
          deliveryAddress: 'Techware Software solution, Carnival Infopark, Kochi',
          deliveryCharge: 'A$ 0.5',
          deliveryLocation: delivery,
          bookDate: firebase.firestore.FieldValue.serverTimestamp(),
          discount: 'A$ 12.00',
          orderCode: this.orderCode(),
          orderId: neworderId,
          orderStatus: 1,
          pickupAddress: 'GetMi, Canberra, AUS',
          pickupLocation: pickup,
          price: 'A$ ' + product.price,
          product: firebase.firestore().doc('/product/' + product.prodId),
          promoId: null,
          qty: product.qty,
          rider: firebase.firestore().doc('/riders/qbTKza18mWVzYG9NLIbmjMbrYjG2'),
          status: 1,
          tax: 'A$ 7.5',
          size: product.size,
          color: product.color,
          custId: this.custId,
          image: product.image,
          prodId: product.prodId,
          prodName: product.prodName,
          riderId: 'qbTKza18mWVzYG9NLIbmjMbrYjG2',
          shopperId: 'qbTKza18mWVzYG9NLIbmjMbrYjG2'
        };
        this.afs.collection('orders').doc(neworderId).set(orderItem).then(() => {
          currProcess += 1;
          console.log('Booking Successfully');
          this.afs.doc(`carts/${product.cartId}`).delete();
          // this.router.navigateByUrl('cart');
          console.log(currProcess, cartCount);
          document.body.scrollTop = document.documentElement.scrollTop = 0;
          if (currProcess === cartCount) {
            // this.router.navigateByUrl('cart');
            return true;
          }
        });
      }).catch((error) => {
        console.error('Error adding document: ', error);
      });
    });

  }*/


  public async checkOut(cart: CartItem[], otherCharge) {
    console.log(cart);
    console.log(this.users);
    const cartGroup = [];
    // const distinctShops = [...new Set(cart.map(obj => obj.shopperId))];
    const distinctShops = [];
    const map = new Map();
    for (const item of cart) {
        if (!map.has(item.shopperId)) {
            map.set(item.shopperId, true);    // set any value to Map
            distinctShops.push(item.shopperId);
        }
    }
    cart.forEach((items) => {
      cartGroup[items.shopperId] = cartGroup[items.shopperId] === undefined ? [] : cartGroup[items.shopperId];
      cartGroup[items.shopperId].push(items);
    });
    const cartCount = distinctShops.length;



    console.log(cartGroup);
    console.log(cartCount);
    const promise = new Promise(resolve => {
    distinctShops.forEach((item) => {
      console.log(item);
      this.afs.collection('orders').add({
        bookDate: firebase.firestore.FieldValue.serverTimestamp()
      }).then((docRef) => {
        const neworderId = docRef.id;
        const delivery = new firebase.firestore.GeoPoint(10.0237, 76.3116);
        const pickup = new firebase.firestore.GeoPoint(10.7231, 76.1234);
        const products = {};
        const cartItem = cartGroup[item];
        let prodPrice = 0;
        cartItem.forEach((prodItem) => {
          prodPrice += prodItem.price;
          products[prodItem.prodId] = {
              prodId: prodItem.prodId,
              prodName: prodItem.prodName,
              image: prodItem.image,
              price: prodItem.price,
              color: prodItem.color,
              size: prodItem.size,
              qty: prodItem.qty,
              discount: ''
          };
          this.afs.doc(`carts/${prodItem.cartId}`).delete();
        });
        console.log(cartItem);
        console.log(products);
        const product = cartItem[0];
        const orderItem: Order = {
          amount: 'A$ ' + otherCharge.totalAmt,
          customer: firebase.firestore().doc('/customer/' + this.custId),
          shopper: product.shopper,
          deliveryAddress: otherCharge.custAddress,
          deliveryCharge: 'A$ ' + otherCharge.deliveryCharge,
          deliveryLocation: delivery,
          bookDate: firebase.firestore.FieldValue.serverTimestamp(),
          orderCode: this.orderCode(),
          orderId: neworderId,
          orderStatus: 1,
          pickupAddress: 'GetMi, Canberra, AUS',
          pickupLocation: pickup,
          promoId: null,
          rider: firebase.firestore().doc('/riders/qbTKza18mWVzYG9NLIbmjMbrYjG2'),
          status: 1,
          custId: this.custId,
          riderId: 'qbTKza18mWVzYG9NLIbmjMbrYjG2',
          shopperId: product.shopperId,
          custName: 'Jone Doe',
          riderName: 'John',
          shopperState: 0,
          shopperName: 'Witchery',
          product: products,
          discount: 'A$ ' + otherCharge.discount,
          promoApplied: otherCharge.discountApplied,
          tax: 'A$ ' + otherCharge.taxAmount
        };
        console.log(orderItem);

        this.afs.collection('orders').doc(neworderId).set(orderItem).then(() => {
          console.log('Booking Successfully');
          // this.router.navigateByUrl('cart');
          resolve('Cart to Order Successfully');
          document.body.scrollTop = document.documentElement.scrollTop = 0;
        });
      }).catch((error) => {
        console.error('Error adding document: ', error);
      });
    });
  });
    promise.then(value => console.log(value));

  }

  public async changeOrder(orderId, status) {
    console.log(orderId, status);
    this.afs.collection('orders').doc(orderId).update({orderStatus: status});
  }

  public async buyNow(product: Products) {
    //
  }

  orderCode() {
    const newpin =  Math.round(Math.random() * 1000000);
    const orderCode = 'GM' + this.pad(newpin, 6, null);
    return orderCode;
  }

  pad(n, width, z) {
    z = z || '0';
    n = n + '';
    return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
  }

  choose_size(size: string) {
    this.size = size;
  }

}
