import { Component, OnInit } from '@angular/core';
import { AddressService } from './../../config/address.service';
import { Router, ActivatedRoute } from '@angular/router';
import { Location } from '@angular/common';

@Component({
  selector: 'app-address',
  templateUrl: './address.page.html',
  styleUrls: ['./address.page.scss']
})
export class AddressPage implements OnInit {
  constructor(
    private location: Location,
    public addressService: AddressService,
    public router: Router
  ) {}

  ngOnInit() {}

  goBack() {
    this.location.back();
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
}
