import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { ServiceService } from './../../config/service.service';

@Component({
  selector: 'app-orderplaced',
  templateUrl: './orderplaced.page.html',
  styleUrls: ['./orderplaced.page.scss']
})
export class OrderplacedPage implements OnInit {
  deliveryTime: any;
  timeinterval: any;
  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    private service: ServiceService
  ) {
    this.deliveryTime = '';
    this.service.get('order').then(val => {
      this.data = val;
      this.timeinterval = setInterval(() => {
        this.getDeliveryTime(this.data.bookDate.seconds);
      }, 1000);
    });
  }
  data: any;

  relatedProd = {
    slidesPerView: 2
  };

  getDeliveryTime(timeStamp) {
    console.log(timeStamp);
    const endDate = new Date(timeStamp * 1000);
    console.log(endDate);
    endDate.setHours(endDate.getHours() + 1);
    const t = this.getTimeRemaining(endDate, new Date());
    const minutes = t.minutes < 10 ? '0' + t.minutes : t.minutes;
    const seconds = t.seconds < 10 ? '0' + t.seconds : t.seconds;
    this.deliveryTime = minutes + ' : ' + seconds;
    if (t.t <= 0) {
      clearInterval(this.timeinterval);
    }
  }

  getTimeRemaining(endtime, currDate) {
    const t = Date.parse(endtime) - Date.parse(currDate);
    const seconds = Math.floor((t / 1000) % 60);
    const minutes = Math.floor((t / 1000 / 60) % 60);
    return {
      t,
      minutes,
      seconds
    };
  }

  ngOnInit() {}

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }
}
