import { Component, OnInit } from '@angular/core';
import { User } from '../../config/services/user';
import { UserService } from '../../config/user.service';
import { ServiceService } from '../../config/service.service';
import { AuthService } from '../../config/auth.service';
import { Router, ActivatedRoute } from '@angular/router';
import { finalize, tap } from 'rxjs/operators';
import { Location } from '@angular/common';
import { AddressService } from './../../config/address.service';
import {
  AngularFireStorage,
  AngularFireStorageReference,
  AngularFireUploadTask
} from '@angular/fire/storage';
import { trigger, transition, animate, style } from '@angular/animations';

@Component({
  selector: 'app-profile',
  templateUrl: './profile.page.html',
  styleUrls: ['./profile.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({ transform: 'translateY(100%)' }),
        animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
      ]),
      transition(':leave', [
        animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
      ])
    ])
  ]
})
export class ProfilePage implements OnInit {
  user: User;
  userdata: any;
  custId: string;
  isShow = false;
  userData: any;
  loggedUser: any;
  ref: AngularFireStorageReference;
  downloadURL;

  constructor(
    private route: ActivatedRoute,
    private router: Router,
    private storage: AngularFireStorage,
    private useService: UserService,
    private service: ServiceService,
    private authService: AuthService,
    private addressService: AddressService,
    private location: Location
  ) {
    this.service.get('user').then(data => {
      if (data) {
        this.userData = JSON.parse(data);
        console.log(this.userData);
      }
    });

    // Listens to url
    route.params.subscribe(val => {
      // Get user Data
      this.service.get('userData').then(data => {
        if (data) {
          this.loggedUser = JSON.parse(data);
        }
      });
    });
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  ngOnInit() {
    console.log('profile page');
    const This = this;
    setTimeout(() => {
      this.user = this.useService.users;
      // console.log('[users]', this.user);
      this.service.set('params', this.user);
    }, 500);
  }

  istoggle() {
    this.isShow = !this.isShow;
  }

  goBack() {
    this.location.back();
  }

  async fileChange(event) {
    const fileList: FileList = event.target.files;
    if (fileList.length > 0) {
      const reader = new FileReader();
      let profilePic;
      reader.onload = (events: any) => {
        profilePic = events.target.result;
        this.loggedUser.profilePhoto = events.target.result;
      };

      profilePic = event.target.result;

      reader.readAsDataURL(event.target.files[0]);

      const file = fileList[0];
      const ext = file.name.split('.').pop();
      if (ext === 'jpg' || ext === 'jpeg' || ext === 'png') {
        const path = file.name; // + Date.now();
        const ref = this.storage.ref(path);
        const task = this.storage
          .upload(path, file)
          .snapshotChanges()
          .pipe(
            finalize(() => {
              ref.getDownloadURL().subscribe(url => {
                this.authService.profilePic(url);
              });
            })
          )
          .subscribe();

        // this.downloadURL = await ref.getDownloadURL().toPromise();
        // console.log(this.downloadURL);
      }
    }
  }
}
