import { Injectable } from '@angular/core';
import {
  AngularFirestore,
  AngularFirestoreCollection,
  AngularFirestoreDocument
} from '@angular/fire/firestore';
import { take } from 'rxjs/operators';
import { ServiceService } from './../config/service.service';
import { Products } from './services/product';

@Injectable({
  providedIn: 'root'
})
export class ProductsService {
  prodSlideImg: any;
  product: Products[] = [];
  fav: any[];
  selItem: Products;
  similar: Products[] = [];
  user: any;
  constructor(public afs: AngularFirestore, public service: ServiceService) {
    this.product = [];
    this.fav = [];
    this.prodSlideImg = [];
    this.service.get('user').then(data => {
      this.user = JSON.parse(data);
      this.getFavlist(this.user.uid);
    });
  }

  // Fetches images for slide
  public async fetchGallery(skuID: string) {
    const This = this;
    const state = true;

    // firebase query
    return new Promise(resolve => {
      const prodRef: AngularFirestoreCollection<any> = this.afs.collection(
        `product_gallery`,
        ref => ref.where('skuId', '==', skuID)
      );
      prodRef.valueChanges().subscribe(value => {
        this.prodSlideImg = [];
        const res = value;
        if (res.length > 0) {
          res.forEach(item => {
            this.prodSlideImg.push(item.downloadURL);
          });
          resolve(this.prodSlideImg);
        } else {
          resolve(this.prodSlideImg);
        }
      });
    });
  }

  public async prodList(shopperId: string) {
    const This = this;
    const state = true;
    // console.log(shopperId);
    const prodRef: AngularFirestoreCollection<any> = this.afs.collection(
      `products`,
      ref =>
        ref
          .orderBy('category', 'asc')
          .where('shopperId', '==', shopperId)
          .where('status', '==', state)
    );
    prodRef.valueChanges().subscribe(value => {
      this.product = [];
      const res = value;
      if (res.length > 0) {
        res.forEach(item => {
          // console.log(item.size);
          const prod: Products = {
            prodId: item.prodId,
            prodName: item.prodName,
            prodCode: item.prodCode,
            prodDesc: item.prodDesc,
            prodStatus: item.prodStatus,
            brand: item.brand,
            category: item.category,
            shopperId: item.shopperId,
            color: this.service.splitSep(item.color),
            discount: item.discount,
            featured: item.featured,
            image: item.image,
            price: item.price,
            qty: item.qty,
            shopper: item.shopper,
            skuCode: item.skuCode,
            status: item.status,
            rating: item.rating,
            size: this.service.splitSep(item.size),
            subCate: item.subCate,
            tag: this.service.splitSep(item.tag)
          };
          this.product.push(prod);
        });
        // console.log(this.product);
      } else {
        // alert('No Products Found');
      }
    });
  }

  public async filterSearch(sortValue: string, shopperId: string) {
    const This = this;
    const state = true;
    // console.log(sortValue);

    let field, order;
    if (sortValue === 'low') {
      field = 'price';
      order = 'asc';
    }

    if (sortValue === 'high') {
      field = 'price';
      order = 'desc';
    }

    if (sortValue === 'a-z') {
      field = 'prodName';
      order = 'asc';
    }

    // tslint:disable-next-line:max-line-length
    const prodRef: AngularFirestoreCollection<any> = this.afs.collection(
      `products`,
      ref =>
        ref
          .where('status', '==', state)
          .where('shopperId', '==', shopperId)
          .orderBy(field, order)
    );
    prodRef.valueChanges().subscribe(value => {
      this.product = [];
      const res = value;
      if (res.length > 0) {
        res.forEach(item => {
          // console.log(item.size);
          const prod: Products = {
            prodId: item.prodId,
            prodName: item.prodName,
            prodCode: item.prodCode,
            prodDesc: item.prodDesc,
            prodStatus: item.prodStatus,
            brand: item.brand,
            category: item.category,
            shopperId: item.shopperId,
            color: item.color,
            discount: item.discount,
            featured: item.featured,
            image: item.image,
            price: item.price,
            qty: item.qty,
            rating: item.rating,
            shopper: item.shopper,
            skuCode: item.skuCode,
            status: item.status,
            size: this.service.splitSep(item.size),
            subCate: item.subCate,
            tag: this.service.splitSep(item.tag)
          };
          this.product.push(prod);
        });
        // console.log(this.product);
      } else {
        // alert('No Products Found');
      }
    });
  }

  similarProd(shopperId, category, subCate, prodId) {
    const This = this;
    const state = true;
    // console.log(shopperId);
    const prodRef: AngularFirestoreCollection<any> = this.afs.collection(
      `products`,
      ref =>
        ref
          .where('shopperId', '==', shopperId)
          .where('status', '==', state)
          .where('category', '==', category)
          .where('subCate', '==', subCate)
          .where('prodId', '>', prodId)
          .where('prodId', '<', prodId)
    );
    prodRef.valueChanges().subscribe(value => {
      this.similar = [];
      const res = value;
      if (res.length > 0) {
        res.forEach(item => {
          // console.log(item.size);
          const prod: Products = {
            prodId: item.prodId,
            prodName: item.prodName,
            prodCode: item.prodCode,
            prodDesc: item.prodDesc,
            prodStatus: item.prodStatus,
            brand: item.brand,
            category: item.category,
            shopperId: item.shopperId,
            color: item.color,
            discount: item.discount,
            featured: item.featured,
            image: item.image,
            price: item.price,
            qty: item.qty,
            shopper: item.shopper,
            rating: item.rating,
            skuCode: item.skuCode,
            status: item.status,
            size: this.service.splitSep(item.size),
            subCate: item.subCate,
            tag: this.service.splitSep(item.tag)
          };
          this.similar.push(prod);
        });
        // console.log(this.similar);
      } else {
        // alert('No Products Found');
      }
    });
  }

  public async setProd(item: Products) {
    this.selItem = item;
  }

  public async getFavlist(userId: string) {
    const favRef: AngularFirestoreDocument<any> = this.afs
      .collection(`favourite`)
      .doc(userId);
    favRef
      .valueChanges()
      .pipe(
        take(1) // Here you can limit to only emit once, using the take operator
      )
      .subscribe(value => {
        if (value !== undefined) {
          if (Object.keys(value).length > 0) {
            this.fav = this.service.splitSep(value);
            // console.log(this.fav);
          }
          // console.log(value);
        }
      });
  }

  public async changeFav(index, type) {
    // console.log(index, type, this.user.uid);
    if (type === 'no') {
      this.afs
        .collection('favourite')
        .doc(this.user.uid)
        .valueChanges()
        .pipe(
          take(1) // Here you can limit to only emit once, using the take operator
        )
        .subscribe(value => {
          if (value === undefined) {
            this.afs
              .collection('favourite')
              .doc(this.user.uid)
              .set({
                [index]: true
              });
          } else {
            // console.log(value);
            value[index] = true;
            // console.log(value);
            this.afs
              .collection('favourite')
              .doc(this.user.uid)
              .set(value);
          }
        });
    } else {
      this.afs
        .collection('favourite')
        .doc(this.user.uid)
        .valueChanges()
        .pipe(
          take(1) // Here you can limit to only emit once, using the take operator
        )
        .subscribe(value => {
          // console.log(value);
          if (value !== undefined) {
            value[index] = undefined;
            Object.keys(value).forEach(key =>
              value[key] === undefined ? delete value[key] : ''
            );
            // console.log(value);
            this.afs
              .collection('favourite')
              .doc(this.user.uid)
              .set(value);
          } else {
            // console.log(value);
          }
        });
    }
  }
}
