import { Injectable } from '@angular/core';
import { AngularFireAuth } from '@angular/fire/auth';
import {
  AngularFirestore,
  AngularFirestoreDocument,
  AngularFirestoreCollection
} from '@angular/fire/firestore';
import { Shopper } from './services/shopper';
import * as firebase from 'firebase';

@Injectable({
  providedIn: 'root'
})
export class ShoppersService {
  shoppers: Shopper[] = [];
  activeshoppers: Shopper[] = [];
  nearshoppers: Shopper[] = [];
  constructor(public afs: AngularFirestore, public afAuth: AngularFireAuth) {
    this.featuredshopperList();
    this.getNearBy(10.0159, 76.3419, 10);
  }

  public async shopperList(centerId: string, type: string) {
    const This = this;
    const state = true;
    const orderRef: AngularFirestoreCollection<any> = this.afs.collection(
      'shoppers',
      ref => ref.where(type, '==', centerId).where('status', '==', state)
    );
    orderRef.valueChanges().subscribe(value => {
      this.shoppers = [];
      const res = value;
      if (res.length > 0) {
        res.forEach(item => {
          // console.log(item);
          const shopper: Shopper = {
            name: item.name,
            emailId: item.emailId,
            phone: item.phone,
            uid: item.uid,
            profilePhoto: item.profilePic,
            status: item.status,
            address: item.address,
            featured: item.featured,
            featuredImage: item.featuredImage,
            shopName: item.shopName,
            shopStatus: item.shopStatus,
            workingHours: item.workingHours,
            caption: item.caption,
            centre: item.centre,
            rate: item.rate,
            centerId: item.centerId
          };
          this.shoppers.push(shopper);
        });
        // console.log(this.shoppers);
      } else {
        // alert('No Orders Found');
      }
    });
  }

  public async featuredshopperList() {
    const This = this;
    const state = true;
    const orderRef: AngularFirestoreCollection<any> = this.afs.collection(
      'shoppers',
      ref => ref.where('featured', '==', state).where('status', '==', state)
    );
    orderRef.valueChanges().subscribe(value => {
      this.activeshoppers = [];
      const res = value;
      if (res.length > 0) {
        res.forEach(item => {
          // console.log(item);
          const shopper: Shopper = {
            name: item.name,
            emailId: item.emailId,
            phone: item.phone,
            uid: item.uid,
            profilePhoto: item.profilePic,
            status: item.status,
            address: item.address,
            featured: item.featured,
            featuredImage: item.featuredImage,
            shopName: item.shopName,
            shopStatus: item.shopStatus,
            workingHours: item.workingHours,
            caption: item.caption,
            centre: item.centre,
            rate: item.rate,
            centerId: item.centerId
          };
          this.activeshoppers.push(shopper);
        });
        // console.log(this.activeshoppers);
      } else {
        // alert('No Orders Found');
      }
    });
  }

  public async getNearBy(latitude, longitude, distance) {
    const This = this;
    const state = true;

    const lat = 0.0144927536231884;
    const lon = 0.0181818181818182;

    const lowerLat = latitude - lat * distance;
    const lowerLon = longitude - lon * distance;

    const greaterLat = latitude + lat * distance;
    const greaterLon = longitude + lon * distance;

    const lesserGeopoint = new firebase.firestore.GeoPoint(lowerLat, lowerLon);
    const greaterGeopoint = new firebase.firestore.GeoPoint(
      greaterLat,
      greaterLon
    );
    const orderRef: AngularFirestoreCollection<any> = this.afs.collection(
      'shoppers',
      ref =>
        ref
          .where('centre.latLng', '>', lesserGeopoint)
          .where('centre.latLng', '<', greaterGeopoint)
          .where('status', '==', state)
    );
    orderRef.valueChanges().subscribe(value => {
      this.nearshoppers = [];
      const res = value;
      if (res.length > 0) {
        res.forEach(item => {
          // console.log(item);
          const shopper: Shopper = {
            name: item.name,
            emailId: item.emailId,
            phone: item.phone,
            uid: item.uid,
            profilePhoto: item.profilePic,
            status: item.status,
            address: item.address,
            featured: item.featured,
            featuredImage: item.featuredImage,
            shopName: item.shopName,
            shopStatus: item.shopStatus,
            workingHours: item.workingHours,
            caption: item.caption,
            centre: item.centre,
            rate: item.rate,
            centerId: item.centerId
          };
          this.nearshoppers.push(shopper);
        });
        // console.log(this.nearshoppers);
      } else {
        // alert('No Orders Found');
      }
    });
  }
}
