import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { MyordersService } from './../../config/myorder.service';
import { ModalController } from '@ionic/angular';
import { DeliverypopPage } from '../deliverypop/deliverypop.page';
import { ServiceService } from './../../config/service.service';
let MyorderPage = class MyorderPage {
    constructor(router, route, location, myorder, modalController, service) {
        this.router = router;
        this.route = route;
        this.location = location;
        this.myorder = myorder;
        this.modalController = modalController;
        this.service = service;
        this.loader = false;
    }
    ngOnInit() {
        const This = this;
        this.loader = true;
        setTimeout(() => {
            This.loader = false;
        }, 500);
        // this.myorder.orderList('WwHnLICVY2dvZGUHuKqasiTB91a2');
    }
    finishpop(data) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const modal = yield this.modalController.create({
                component: DeliverypopPage,
                componentProps: data
            });
            return yield modal.present();
        });
    }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        this.location.back();
    }
    orderDetails(index) {
        this.myorder.trackOrder(this.myorder.orders[index]);
        this.router.navigateByUrl('trackorder');
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    acceptOrder(order) {
        if (order.orderStatus === 7) {
            this.finishpop(order);
        }
    }
    viewOrder(data) {
        console.log(data);
        this.service.set('order', data);
        this.router.navigateByUrl('orderplaced', { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    getStatus(status) {
        switch (status) {
            case 1:
                return 'Booked';
                break;
            case 2:
                return 'Shop Accepted';
                break;
            case 3:
                return 'Rider Assigned';
                break;
            case 4:
                return 'Reached Shop';
                break;
            case 5:
                return 'Picked Up';
                break;
            case 6:
                return 'Reached Location';
                break;
            case 7:
                return 'Delivered';
                break;
            case 9:
                return 'Completed';
                break;
            case 8:
                return 'Rejected';
                break;
            case 10:
                return 'Not Received';
                break;
            case 0:
                return 'Cancelled';
                break;
            default:
                return 'Finished';
        }
    }
};
MyorderPage = tslib_1.__decorate([
    Component({
        selector: 'app-myorder',
        templateUrl: './myorder.page.html',
        styleUrls: ['./myorder.page.scss'],
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        ActivatedRoute,
        Location,
        MyordersService,
        ModalController,
        ServiceService])
], MyorderPage);
export { MyorderPage };
//# sourceMappingURL=myorder.page.js.map