import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { ServiceService } from './../../config/service.service';
import { MyordersService } from './../../config/myorder.service';
let OrderplacedPage = class OrderplacedPage {
    constructor(router, route, location, service, myOrder) {
        this.router = router;
        this.route = route;
        this.location = location;
        this.service = service;
        this.myOrder = myOrder;
        this.relatedProd = {
            slidesPerView: 2
        };
        this.deliveryTime = '';
        this.service.get('order').then(val => {
            this.data = val;
            this.timeinterval = setInterval(() => {
                this.getDeliveryTime(this.data.bookDate.seconds);
            }, 1000);
        });
    }
    getDeliveryTime(timeStamp) {
        console.log(timeStamp);
        const endDate = new Date(timeStamp * 1000);
        console.log(endDate);
        endDate.setHours(endDate.getHours() + 1);
        const t = this.getTimeRemaining(endDate, new Date());
        const minutes = t.minutes < 10 ? '0' + t.minutes : t.minutes;
        const seconds = t.seconds < 10 ? '0' + t.seconds : t.seconds;
        this.deliveryTime = minutes + ' : ' + seconds;
        if (t.t <= 0) {
            clearInterval(this.timeinterval);
        }
    }
    getTimeRemaining(endtime, currDate) {
        const t = Date.parse(endtime) - Date.parse(currDate);
        this.cancelDelivery = t;
        const seconds = Math.floor((t / 1000) % 60);
        const minutes = Math.floor((t / 1000 / 60) % 60);
        return {
            t,
            minutes,
            seconds
        };
    }
    ngOnInit() { }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        this.location.back();
    }
    cancellOrder(orderId) {
        console.log(orderId);
        this.myOrder.cancelOrder(orderId).then(() => {
            this.service.showToast('Order cancelled!', 'top', 'my-toast', 1000);
            const This = this;
            setTimeout(() => {
                This.goToPage('ordercancelled');
            }, 1100);
        });
    }
    getStatus(status) {
        switch (status) {
            case 1:
                return 'Booked';
                break;
            case 2:
                return 'Shop Accepted';
                break;
            case 3:
                return 'Rider Assigned';
                break;
            case 4:
                return 'Reached Shop';
                break;
            case 5:
                return 'Picked Up';
                break;
            case 6:
                return 'Reached Location';
                break;
            case 7:
                return 'Delivered';
                break;
            case 9:
                return 'Completed';
                break;
            case 8:
                return 'Rejected';
                break;
            case 10:
                return 'Not Received';
                break;
            case 0:
                return 'Cancelled';
                break;
            default:
                return 'Finished';
        }
    }
};
OrderplacedPage = tslib_1.__decorate([
    Component({
        selector: 'app-orderplaced',
        templateUrl: './orderplaced.page.html',
        styleUrls: ['./orderplaced.page.scss']
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        ActivatedRoute,
        Location,
        ServiceService,
        MyordersService])
], OrderplacedPage);
export { OrderplacedPage };
//# sourceMappingURL=orderplaced.page.js.map