import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { AngularFirestore } from '@angular/fire/firestore';
import { ServiceService } from './service.service';
let CategoriesService = class CategoriesService {
    constructor(afs, service) {
        this.afs = afs;
        this.service = service;
        this.categories = [];
        this.activecategories = [];
        this.preferenceList = [];
        this.categoryList();
        this.activeCategory();
    }
    categoryList() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const orderRef = this.afs.collection('shopcategory');
            orderRef.valueChanges().subscribe(value => {
                this.categories = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item);
                        const category = {
                            catId: item.catId,
                            catName: item.catName,
                            catImage: item.catImage,
                            featured: item.featured,
                            status: item.status
                        };
                        this.categories.push(category);
                    });
                    // console.log(this.categories);
                }
                else {
                    // alert('No Orders Found');
                }
            });
        });
    }
    activeCategory() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            const orderRef = this.afs.collection('shopcategory', ref => ref.where('status', '==', state));
            orderRef.valueChanges().subscribe(value => {
                this.activecategories = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item);
                        const category = {
                            catId: item.catId,
                            catName: item.catName,
                            catImage: item.catImage,
                            featured: item.featured,
                            status: item.status
                        };
                        this.activecategories.push(category);
                    });
                    // console.log(this.activecategories);
                }
                else {
                    // alert('No Orders Found');
                }
            });
        });
    }
    preference(custId) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            const promise = new Promise(resolve => {
                const orderRef = this.afs
                    .collection('preference')
                    .doc(custId);
                orderRef.valueChanges().subscribe(value => {
                    console.log(value);
                    this.preferenceList = [];
                    if (value) {
                        console.log(value);
                        // tslint:disable-next-line: forin
                        for (const index in value) {
                            console.log(index);
                            this.preferenceList.push(index);
                            resolve(this.preferenceList);
                        }
                        resolve();
                        // console.log(this.activecategories);
                    }
                    else {
                        this.preferenceList = [];
                        resolve([]);
                    }
                });
            });
            return promise;
        });
    }
    preferenceCreate(preferData, custId) {
        if (preferData.length > 0) {
            const preferArray = [];
            preferData.forEach(element => {
                preferArray[element] = true;
            });
            const pref = Object.assign({}, preferArray);
            this.afs
                .collection('preference')
                .doc(custId)
                .set(pref);
        }
        else {
            this.afs
                .collection('preference')
                .doc(custId)
                .delete();
        }
    }
};
CategoriesService = tslib_1.__decorate([
    Injectable({
        providedIn: 'root'
    }),
    tslib_1.__metadata("design:paramtypes", [AngularFirestore, ServiceService])
], CategoriesService);
export { CategoriesService };
//# sourceMappingURL=category.service.js.map