import * as tslib_1 from "tslib";
import { Injectable } from "@angular/core";
import { AngularFirestore } from "@angular/fire/firestore";
import * as firebase from "firebase";
let CenterService = class CenterService {
    constructor(afs) {
        this.afs = afs;
        this.centers = [];
        this.nearcenters = [];
        this.centerList();
        this.getNearBy(10.0159, 76.3419, 10);
    }
    centerList() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            const orderRef = this.afs.collection("centers", ref => ref.where("featured", "==", state).where("status", "==", state));
            orderRef.valueChanges().subscribe(value => {
                this.centers = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item);
                        if (item.centerName === undefined) {
                            return;
                        }
                        const center = {
                            centerName: item.centerName,
                            description: item.description,
                            location: item.location,
                            latLng: item.latLng,
                            featured: item.featured,
                            centerImg: item.centerImg,
                            status: item.status,
                            cId: item.cId
                        };
                        this.centers.push(center);
                    });
                    // console.log(this.centers);
                }
                else {
                    // alert('No Orders Found');
                }
            });
        });
    }
    getNearBy(latitude, longitude, distance) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            const lat = 0.0144927536231884;
            const lon = 0.0181818181818182;
            const lowerLat = latitude - lat * distance;
            const lowerLon = longitude - lon * distance;
            const greaterLat = latitude + lat * distance;
            const greaterLon = longitude + lon * distance;
            const lesserGeopoint = new firebase.firestore.GeoPoint(lowerLat, lowerLon);
            const greaterGeopoint = new firebase.firestore.GeoPoint(greaterLat, greaterLon);
            const orderRef = this.afs.collection("centers", ref => ref
                .where("latLng", ">", lesserGeopoint)
                .where("latLng", "<", greaterGeopoint)
                .where("status", "==", state));
            orderRef.valueChanges().subscribe(value => {
                this.nearcenters = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item);
                        if (item.centerName === undefined) {
                            return;
                        }
                        const center = {
                            centerName: item.centerName,
                            description: item.description,
                            location: item.location,
                            latLng: item.latLng,
                            featured: item.featured,
                            centerImg: item.centerImg,
                            status: item.status,
                            cId: item.cId
                        };
                        this.nearcenters.push(center);
                    });
                    // console.log(this.nearcenters);
                }
                else {
                    // alert('No Orders Found');
                }
            });
        });
    }
};
CenterService = tslib_1.__decorate([
    Injectable({
        providedIn: "root"
    }),
    tslib_1.__metadata("design:paramtypes", [AngularFirestore])
], CenterService);
export { CenterService };
//# sourceMappingURL=center.service.js.map