import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Location } from '@angular/common';
import { CategoriesService } from './../../config/category.service';
import { ServiceService } from './../../config/service.service';
import { SearchmodalPage } from '../searchmodal/searchmodal.page';
import { SubjectService } from './../../config/subject.service';
import { ModalController } from '@ionic/angular';


@Component({
  selector: 'app-catagory',
  templateUrl: './catagory.page.html',
  styleUrls: ['./catagory.page.scss'],
})
export class CatagoryPage implements OnInit {
  data: any;
  constructor(
    public router: Router,
    public location: Location,
    public categoriesService: CategoriesService,
    public service: ServiceService,
    private subjectService: SubjectService,
    public modalController: ModalController
  ) {
    this.service.get('params').then((val) => {
      this.data = val;
    });
  }

  ngOnInit() {
  }

  goToPage(path, data = null) {
    this.service.set('params', data);
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }

  async searchModal() {
    this.subjectService.setTabData(false);
    const modal = await this.modalController.create({
      component: SearchmodalPage
    });
    modal.onDidDismiss().then(dataReturned => {
      this.subjectService.setTabData(true);
    });
    return await modal.present();
  }

}
