import { Component, OnInit } from '@angular/core';
import { SubjectService } from './../../config/subject.service';
import { ServiceService } from './../../config/service.service';
import { Router, ActivatedRoute } from '@angular/router';

@Component({
  selector: 'app-firstpage',
  templateUrl: './firstpage.page.html',
  styleUrls: ['./firstpage.page.scss'],
})
export class FirstpagePage implements OnInit {
  loader: boolean;
  constructor(
    private subjectService: SubjectService,
    private service: ServiceService,
    private router: Router,
  ) {
    this.loader = true;
    this.service.get('landing').then(data => {
      if (data === true) {
        const user = JSON.parse(localStorage.getItem('user'));
        console.log(user);
        if (user) {
          this.subjectService.sendLoginData(false);
          this.goToPage('home');
        } else {
          this.subjectService.sendLoginData(true);
          this.goToPage('login');
        }
      } else {
        this.goToPage('landing');
      }
      this.loader = false;
    });
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { replaceUrl: true, queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  ngOnInit() {
  }

}
