import { Component, OnInit, ViewChild } from '@angular/core';
import { IonSlides } from '@ionic/angular';
import { Router, ActivatedRoute } from '@angular/router';
import { ServiceService } from './../../config/service.service';
import { SubjectService } from './../../config/subject.service';

@Component({
  selector: 'app-landing',
  templateUrl: './landing.page.html',
  styleUrls: ['./landing.page.scss']
})
export class LandingPage implements OnInit {
  loader: boolean;
  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private service: ServiceService,
    public subjectService: SubjectService
  ) {
  }

  slideOpts = {
    initialSlide: 0,
    speed: 1000,
    allowTouchMove: false
  };

  @ViewChild(IonSlides, { static: false }) slides: IonSlides;
  currentIndex: any;

  landingOptions = {
    initialSlide: 1,
    speed: 1000,
    allowTouchMove: true
  };

  ngOnInit() { }

  goToPage(path, data = null) {
    this.service.set('landing', true);
    this.router.navigateByUrl(path, { replaceUrl: true, queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  next() {
    this.slides.slideNext();
  }

  prev() {
    this.slides.slidePrev();
  }

  slideChanged() {
    this.slides.getActiveIndex().then(index => {
      this.currentIndex = index;
      console.log(this.currentIndex);
    });
  }
}
