import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { MyordersService } from './../../config/myorder.service';
import { ModalController } from '@ionic/angular';
import { DeliverypopPage } from '../deliverypop/deliverypop.page';
import { ServiceService } from './../../config/service.service';

@Component({
  selector: 'app-myorder',
  templateUrl: './myorder.page.html',
  styleUrls: ['./myorder.page.scss'],
})
export class MyorderPage implements OnInit {
  loader = false;
  userData: any;
  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    public myorder: MyordersService,
    public modalController: ModalController,
    public service: ServiceService
  ) { }

  ngOnInit() {
    const This = this;
    this.loader = true;
    setTimeout(() => {
      This.loader = false;
    }, 500);
    this.service.get('user').then(data => {
      if (data) {
        this.userData = JSON.parse(data);
        console.log(this.userData.uid);
        this.myorder.orderList(this.userData.uid);
      }
    });

  }

  async finishpop(data: any) {
    const modal = await this.modalController.create({
      component: DeliverypopPage,
      componentProps: data
    });
    return await modal.present();
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }

  orderDetails(index: number) {
    this.myorder.trackOrder(this.myorder.orders[index]);
    this.router.navigateByUrl('trackorder');
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  acceptOrder(order: any) {
    if (order.orderStatus === 7) {
      this.finishpop(order);
    }
  }

  viewOrder(data) {
    console.log(data);
    this.service.set('order', data);
    this.router.navigateByUrl('orderplaced', { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  getStatus(status: number) {
    switch (status) {
      case 1:
        return 'Booked';
        break;
      case 2:
        return 'Shop Accepted';
        break;
      case 3:
        return 'Rider Assigned';
        break;
      case 4:
        return 'Reached Shop';
        break;
      case 5:
        return 'Picked Up';
        break;
      case 6:
        return 'Reached Location';
        break;
      case 7:
        return 'Delivered';
        break;
      case 9:
        return 'Completed';
        break;
      case 8:
        return 'Rejected';
        break;
      case 10:
        return 'Not Received';
        break;
      case 0:
        return 'Cancelled';
        break;
      default:
        return 'Finished';
    }
  }

  unEscape(text: string) {
    return unescape(text);
  }

}
