import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { Products } from './../../config/services/product';
import { Slides } from './../../config/services/slides';

import { Order } from './../../config/services/order';
import { CartsService } from './../../config/cart.service';
import { ProductsService } from './../../config/products.service';
import { ServiceService } from './../../config/service.service';
import { SocialSharing } from '@ionic-native/social-sharing/ngx';
import { map } from 'rxjs/operators';


@Component({
  selector: 'app-productdetail',
  templateUrl: './productdetail.page.html',
  styleUrls: ['./productdetail.page.scss']
})
export class ProductdetailPage implements OnInit {
  disCart = true;
  slide: Slides;
  product: Products;
  order: Order;
  data: any;
  slideData: any[];
  loader: boolean;

  bannerOptions = {
    slidesPerView: 1,
    speed: 2000,
    autoplay: true
  };
  slideOpts = {
    slidesPerView: 3.5
  };

  relatedProd = {
    slidesPerView: 2
  };

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    private cartService: CartsService,
    private prodService: ProductsService,
    private service: ServiceService,
    private socialSharing: SocialSharing
  ) {
    const params = this.prodService.selItem;
    this.service.state = true;
    this.loader = true;
    this.prodService.similarProd(
      params.shopperId,
      params.category,
      params.subCate,
      params.prodId
    );
    this.service.get('params').then(val => {
      this.data = val;
    });
    this.cartService.cartList();
    setTimeout(() => {
      this.loader = false;
    }, 1000);
    // console.log(this.prodService.fav);
  }

  ngOnInit() {
    // console.log("[qwe]", this.prodService.selItem);

    const params = this.prodService.selItem;
    this.getProd(params);
  }

  unEscape(text: string) {
    return unescape(text);
  }

  getProd(params) {
    if (params) {
      let slideItem = [];
      slideItem.push(params.image);
      this.slideData = slideItem;
      const prod: Products = {
        prodId: params.prodId,
        subCate: params.subCate,
        tag: params.tag,
        prodName: params.prodName,
        prodCode: params.prodCode,
        prodDesc: params.prodDesc,
        prodStatus: params.prodStatus,
        brand: params.brand,
        category: params.category,
        shopperId: params.shopperId,
        color: params.color,
        discount: params.discount,
        featured: params.featured,
        centerId: params.centerId,
        centerRef: params.center,
        image: params.image,
        price: params.price,
        qty: params.qty,
        rating: params.rating,
        shopper: params.shopper,
        skuCode: params.skuCode,
        status: params.status,
        size: params.size
      };
      this.product = prod;
      this.prodService.fetchGallery(params.skuCode).then((galleryData: any) => {
        slideItem = galleryData;
        this.slideData = slideItem;
      });
    } else {
      this.product = undefined;
    }
    // console.log(this.product.image);
  }

  stringObject(items: any) {
    items.forEach(element => {
      // console.log(element.sizeId);
      element = JSON.parse(element);
      // console.log(element);
    });
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.service.state = false;
    this.location.back();
  }

  buyNow(product: any, type: number) {
    this.cartService.buyNow(product).then(() => {
      if (type === 1) {
        this.router.navigateByUrl('cart');
      } else {
        this.service.showToast('Added into cart', 'top', 'my-toast', 2000);
      }
      this.cartService.cartList();
    });
  }

  viewProd(prod) {
    this.getProd(prod);
  }

  checkFavStatus(index) {
    const state = this.prodService.fav.findIndex(x => x === index);
    return state > -1 ? 'fav_active' : 'fav';
  }

  changeFav(index) {
    this.prodService.changeFav(index, 'yes');
    const state = this.prodService.fav.findIndex(x => x === index);
    // console.log(state);
    // console.log(this.prodService.fav);
    if (state > -1) {
      this.prodService.fav.splice(state, 1);
      this.prodService.changeFav(index, 'yes');
    } else {
      this.prodService.fav.push(index);
      this.prodService.changeFav(index, 'no');
    }
    return;
    // console.log(this.prodService.fav);
  }

  socialShare(prodName, category, subCate, price, image) {
    const desc = category + ', ' + subCate + ', ' + price;
    const content = {
      message: desc, // not supported on some apps (Facebook, Instagram)
      subject: prodName, // fi. for email
      files: image,
      chooserTitle: 'GetMi'
    };
    this.socialSharing.shareWithOptions(content);
  }
}
