import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { ModalController, NavParams } from '@ionic/angular';
import { SearchService } from './../../config/search.service';
import { ServiceService } from './../../config/service.service';
import { ProductsService } from './../../config/products.service';

@Component({
  selector: 'app-searchmodal',
  templateUrl: './searchmodal.page.html',
  styleUrls: ['./searchmodal.page.scss']
})
export class SearchmodalPage implements OnInit {
  searchShow = false;
  constructor(
    private modalController: ModalController,
    private navParams: NavParams,
    private searchService: SearchService,
    public service: ServiceService,
    private productsService: ProductsService,
    private router: Router
  ) { }

  ngOnInit() {
    this.searchService.searchList = [];
  }

  async closeModal() {
    await this.modalController.dismiss();
  }

  searchFun(data: string) {
    this.searchShow = true;
    this.searchService.search(data);
  }

  clickSearch() {
    this.searchShow = true;
    this.searchService.searchList = [];
  }

  viewPage(datas: any) {
    this.closeModal();
    console.log(datas);
    let data;
    let url;
    if (datas.type === 'shopper') {
      data = datas.data;
      this.service.set('params', data);
      url = 'productlist';
    } else if (datas.type === 'category') {
      data = datas.data;
      this.service.set('params', data);
      url = 'catstorelist';
    } else {
      data = datas.data;
      data.size = this.service.splitSep(data.size);
      data.tag = this.service.splitSep(data.tag);
      (data.color = this.service.splitSep(data.color)), (url = 'productdetail');
      this.productsService.setProd(data);
    }
    this.searchClose();
    this.router.navigateByUrl(url, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  searchClose() {
    this.closeModal();
    this.searchShow = false;
  }

  unEscape(text: string) {
    return unescape(text);
  }




}
