import { Injectable } from '@angular/core';
import {
  AngularFirestore,
  AngularFirestoreDocument,
  AngularFirestoreCollection
} from '@angular/fire/firestore';
import { Centers, CenterData } from './services/center';
import * as firebase from 'firebase';

@Injectable({
  providedIn: 'root'
})
export class CenterService {
  centers: Centers[] = [];
  nearcenters: Centers[] = [];
  constructor(public afs: AngularFirestore) {
    this.centerList();
    this.getNearBy(10.0159, 76.3419, 10);
  }

  public async centerList() {
    const This = this;
    const state = true;
    const orderRef: AngularFirestoreCollection<any> = this.afs.collection(
      'centers',
      ref => ref.where('featured', '==', state).where('status', '==', state)
    );
    orderRef.valueChanges().subscribe(value => {
      this.centers = [];
      const res = value;
      if (res.length > 0) {
        res.forEach(item => {
          // console.log(item);
          if (item.centerName === undefined) {
            return;
          }
          const center: Centers = {
            centerName: item.centerName,
            description: item.description,
            location: item.location,
            latLng: item.latLng,
            featured: item.featured,
            centerImg: item.centerImg,
            status: item.status,
            cId: item.cId
          };
          this.centers.push(center);
        });
        // console.log(this.centers);
      } else {
        // alert('No Orders Found');
      }
    });
  }

  public async getNearBy(latitude, longitude, distance) {
    const This = this;
    const state = true;

    const lat = 0.0144927536231884;
    const lon = 0.0181818181818182;

    const lowerLat = latitude - lat * distance;
    const lowerLon = longitude - lon * distance;

    const greaterLat = latitude + lat * distance;
    const greaterLon = longitude + lon * distance;

    const lesserGeopoint = new firebase.firestore.GeoPoint(lowerLat, lowerLon);
    const greaterGeopoint = new firebase.firestore.GeoPoint(
      greaterLat,
      greaterLon
    );
    const orderRef: AngularFirestoreCollection<any> = this.afs.collection(
      'centers',
      ref =>
        ref
          .where('latLng', '>', lesserGeopoint)
          .where('latLng', '<', greaterGeopoint)
          .where('status', '==', state)
    );
    orderRef.valueChanges().subscribe(value => {
      this.nearcenters = [];
      const res = value;
      if (res.length > 0) {
        res.forEach(item => {
          // console.log(item);
          if (item.centerName === undefined) {
            return;
          }
          const center: Centers = {
            centerName: item.centerName,
            description: item.description,
            location: item.location,
            latLng: item.latLng,
            featured: item.featured,
            centerImg: item.centerImg,
            status: item.status,
            cId: item.cId
          };
          this.nearcenters.push(center);
        });
        // console.log(this.nearcenters);
      } else {
        // alert('No Orders Found');
      }
    });
  }
}
