import { Component } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Platform } from '@ionic/angular';
import { SplashScreen } from '@ionic-native/splash-screen/ngx';
import { StatusBar } from '@ionic-native/status-bar/ngx';
import { AngularFirestore, AngularFirestoreDocument, AngularFirestoreCollection } from '@angular/fire/firestore';
import * as firebase from 'firebase';
import { ModalController } from '@ionic/angular';
import { DeliverypopPage } from './deliverypop/deliverypop.page';
import { AuthService } from './../config/auth.service';


@Component({
  selector: 'app-root',
  templateUrl: 'app.component.html',
  styleUrls: ['app.component.scss']
})
export class AppComponent {
  constructor(
    private platform: Platform,
    private splashScreen: SplashScreen,
    private statusBar: StatusBar,
    private router: Router,
    public afs: AngularFirestore,
    public modalController: ModalController,
    public authService: AuthService
  ) {
    this.initializeApp();
    this.orderState();
  }


  initializeApp() {
    this.platform.ready().then(() => {
      this.statusBar.styleDefault();
      this.statusBar.overlaysWebView(true);
      this.statusBar.hide();
    });
  }

  async finishpop(data: any) {
    const modal = await this.modalController.create({
      component: DeliverypopPage,
      componentProps: data
    });
    return await modal.present();
  }

  orderState() {
    console.log('called');
    const custId = 'WwHnLICVY2dvZGUHuKqasiTB91a2';
    firebase.firestore().collection('orders').where('custId', '==', custId)
    .onSnapshot((snapData) => {
      snapData.docChanges().forEach((change) => {
        if (change.type === 'modified') {
          const data = change.doc.data();
          if (data.orderStatus === 7) {
            this.finishpop(data);
          }
        }
      });
    });

    /*



    .onSnapshot(function(snapshot) {
        snapshot.docChanges().forEach(function(change) {
            if (change.type === "added") {
                console.log("New city: ", change.doc.data());
            }
            if (change.type === "modified") {
                console.log("Modified city: ", change.doc.data());
            }
            if (change.type === "removed") {
                console.log("Removed city: ", change.doc.data());
            }
        });
    }); */

  }



  vieworder(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
}
