import { Component, OnInit, ViewChild, } from '@angular/core';
import { IonSlides } from '@ionic/angular';
import { Router, ActivatedRoute } from '@angular/router';
import { ServiceService } from './../../config/service.service';

@Component({
  selector: 'app-landing',
  templateUrl: './landing.page.html',
  styleUrls: ['./landing.page.scss'],
})
export class LandingPage implements OnInit {

  slideOpts = {
    initialSlide: 0,
    speed: 1000,
    allowTouchMove: false
  };

  @ViewChild(IonSlides, { static: false })slides: IonSlides;
  currentIndex: any;
  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private service: ServiceService
    ) {
      this.service.get('landing').then((data) => {
        if (data === true) {
          const user = JSON.parse(localStorage.getItem('user'));
          console.log(user);
          if (user) {
            this.goToPage('home');
          } else {
            this.goToPage('login');
          }
        }
      });
    }

  ngOnInit() {
  }

  goToPage(path, data = null) {
    this.service.set('landing', true);
    this.router.navigateByUrl(path, {replaceUrl: true});
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  landingOptions = {
    initialSlide: 1,
    speed: 1000,
    allowTouchMove: false
  };


  next() {
    this.slides.slideNext();
  }

  prev() {
    this.slides.slidePrev();
  }

  slideChanged() {
    this.slides.getActiveIndex().then(index => {
      this.currentIndex = index;
      console.log(this.currentIndex);

    });
  }

}
