import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { Products } from './../../config/services/product';
import { Order } from './../../config/services/order';
import { CartsService } from './../../config/cart.service';
import { ProductsService } from './../../config/products.service';
import { map } from 'rxjs/operators';

@Component({
  selector: 'app-productdetail',
  templateUrl: './productdetail.page.html',
  styleUrls: ['./productdetail.page.scss'],
})
export class ProductdetailPage implements OnInit {
  product: Products;
  order: Order;

  slideOpts = {
    slidesPerView: 3.5
  };

  relatedProd = {
    slidesPerView: 2
  };

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    private cartService: CartsService,
    private prodService: ProductsService
  ) {
  }

  ngOnInit() {
    console.log('here');
    const params = this.prodService.selItem;
    if (params) {
      const prod: Products = {
          prodId: params.prodId,
          prodName: params.prodName,
          prodCode: params.prodCode,
          prodDesc: params.prodDesc,
          prodStatus: params.prodStatus,
          brand: params.brand,
          category: params.category,
          shopperId: params.shopperId,
          color: params.color,
          discount: params.discount,
          featured: params.featured,
          image: params.image,
          price: params.price,
          qty: params.qty,
          shopper: params.shopper,
          skuCode: params.skuCode,
          status: params.status,
          size: params.size,
          currency: params.currency
      };
      this.product = prod;
    } else {
      this.product = undefined;
    }
    console.log(this.product);
  }

  stringObject(items: any) {
    items.forEach(element => {
      console.log(element.sizeId);
      element = JSON.parse(element);
      console.log(element);
    });
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }

  buyNow(product: any, type: number) {
    this.cartService.buyNow(product).then(() => {
      if (type === 1) {
        this.router.navigateByUrl('cart');
      } else {
        alert('Product added to cart');
      }
    });
  }

}
