import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router, ActivatedRoute, NavigationExtras } from '@angular/router';
import { ProductsService } from './../../config/products.service';


@Component({
  selector: 'app-productlist',
  templateUrl: './productlist.page.html',
  styleUrls: ['./productlist.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({ transform: 'translateY(100%)' }),
        animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
      ]),
      transition(':leave', [
        animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
      ])
    ])
  ]
})
export class ProductlistPage implements OnInit {

  onGrid = false;
  isShow = false;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    public prodService: ProductsService
  ) { }

  ngOnInit() {
    this.prodService.prodList();
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  istoggle() {
    this.isShow = !this.isShow;
  }

  goBack() {
    // this.location.back();
    window.history.back();
  }

  gridToggle(){
    this.onGrid = !this.onGrid;
  }

  prodDetails(index: number) {
    this.prodService.setProd(this.prodService.product[index]);
    this.router.navigateByUrl('productdetail');
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
}
