import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Location } from '@angular/common';

@Component({
  selector: 'app-storelist',
  templateUrl: './storelist.page.html',
  styleUrls: ['./storelist.page.scss'],
})
export class StorelistPage implements OnInit {

  slideOpts = {
    slidesPerView: 1.5
  };

  constructor(
    public router: Router,
    public location: Location
  ) { }

  ngOnInit() {
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }

}
