import { Injectable } from '@angular/core';
import { AngularFirestore, AngularFirestoreDocument, AngularFirestoreCollection } from '@angular/fire/firestore';
import { Router, ActivatedRoute } from '@angular/router';
import { Products } from './services/product';
import { Cart, CartItem } from './services/cart';
import { ServiceService } from './service.service';
import * as firebase from 'firebase';
import { take } from 'rxjs/operators';
import { User } from './services/user';
import { from } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class CartsService {
  size: string;
  color: string;
  custId: string;
  prodId: string;
  cart: Cart;
  user: User;
  carts: CartItem[] = [];
  cartTotal: number;

  constructor(
    public afs: AngularFirestore,
    public router: Router,
    public service: ServiceService
  ) {
    this.size = 'Small';
    this.custId = '';
    const users = this.service.get('user').then((data) => {
      if (data) {
        data = JSON.parse(data);
        this.custId = data.uid;
        console.log(this.custId);
      } else {
        this.custId = 'WwHnLICVY2dvZGUHuKqasiTB91a2';
      }
    });
  }

  public async buyNow(product: Products) {
    this.color = 'Blue';
    this.prodId = product.prodId;
    const prodRef = firebase.firestore().collection('products').doc(this.prodId);

    const cartRef: AngularFirestoreCollection<any> = this.afs.collection('carts', ref => ref.where('size', '==', this.size)
    .where('color', '==', this.color)
    .where('custId', '==', this.custId)
    .where('product', '==', prodRef)
    );
    cartRef.valueChanges().pipe(take(1)).subscribe((value: Cart[]) => {
      console.log(value);
      if (value.length === 0) {
        const cart: Cart = {
          color: this.color,
          custId: this.custId,
          shopperId: product.shopperId,
          product: firebase.firestore().doc(`products/${this.prodId}`),
          image: product.image,
          prodId: product.prodId,
          price: product.price,
          prodName: product.prodName,
          shopper: product.shopper,
          qty: 1,
          size: this.size
        };
        this.afs.collection('carts').add(cart).then((docRef) => {
          const neworderId = docRef.id;
          this.afs.collection('carts').doc(neworderId).update({cartId: docRef.id}).then(() => {
            console.log('Booking Successfully');
            document.body.scrollTop = document.documentElement.scrollTop = 0;
          });
        }).catch((error) => {
          console.error('Error adding document: ', error);
        });
      } else {
        alert('Item already added in the cart');
      }
    });
  }

  public async cartList() {
    const cartRef: AngularFirestoreCollection<any> = this.afs.collection('carts', ref => ref.where('custId', '==', this.custId));
    cartRef.valueChanges().subscribe((value) => {
      this.carts = [];
      const res = value;
      this.cartTotal = 0;
      if (res.length > 0) {
        res.forEach((item) => {
          const cartItem: CartItem = {
            cartId: item.cartId,
            color: item.color,
            shopperId: item.shopperId,
            shopper: item.shopper,
            prodId: item.prodId,
            price: item.price,
            prodName: item.prodName,
            image: item.image,
            qty: item.qty,
            size: item.size,
          };
          this.cartTotal += item.price;
          /*const prodItem = item.product.get().then((property) => {
            const response = property.data();
            cartItem.prodName = response.prodName;
            cartItem.price = response.price;
            cartItem.image = response.image;
            cartItem.prodId = response.prodId;
            cartItem.shopperId = response.shopper;
            this.cartTotal += response.price;
          });*/
          this.carts.push(cartItem);
        });
      } else {
       // alert('No Products Found');
      }
    });
  }

  choose_size(size: string) {
    this.size = size;
  }



}
