import { Injectable } from '@angular/core';
import { Storage } from '@ionic/storage';

@Injectable({
  providedIn: 'root'
})
export class ServiceService {

  constructor(public storage: Storage) { }

  public set(settingName: string, value: any) {
    return this.storage.set(`setting:${ settingName }`, value);
  }

  public async get(settingName: string) {
    return await this.storage.get(`setting:${ settingName }`);
  }

  public async remove(settingName: string) {
    return await this.storage.remove(`setting:${ settingName }`);
  }

  public clear() {
    this.storage.clear().then(() => {
      console.log('all keys cleared');
    });
  }

  public key2Array(item: object) {
    const response = [];
    for (const key in item) {
      if (item.hasOwnProperty(key)) {
          response.push(item[key]);
      }
    }
    return response;
  }


}
