import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { Location } from '@angular/common';
import { ServiceService } from './../../config/service.service';
import { ShoppersService } from './../../config/shopper.service';

@Component({
  selector: 'app-catstorelist',
  templateUrl: './catstorelist.page.html',
  styleUrls: ['./catstorelist.page.scss'],
})
export class CatStorelistPage implements OnInit {

  slideOpts = {
    slidesPerView: 1.5
  };
  data: any;

  constructor(
    public router: Router,
    public location: Location,
    public service: ServiceService,
    public shopperService: ShoppersService,
  ) {
    this.service.get('params').then((val) => {
      this.data = val;
      this.shopperService.shopperList(this.data.catId, 'catId');
    });
  }

  ngOnInit() {}

  goToPage(path, data = null) {
    this.service.set('params', data);
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }

}
