import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router, ActivatedRoute } from '@angular/router';
import {  MenuController } from '@ionic/angular';
import {  CenterService } from './../../config/center.service';
import { ShoppersService } from './../../config/shopper.service';
import { CategoriesService } from './../../config/category.service';
import { ServiceService } from './../../config/service.service';
import { from } from 'rxjs';
import { ModalController } from "@ionic/angular";

@Component({
  selector: "app-home",
  templateUrl: "./home.page.html",
  styleUrls: ["./home.page.scss"],
  animations: [
    trigger("slideInOut", [
      transition(":enter", [
        style({ transform: "translateY(100%)" }),
        animate("200ms ease-in", style({ transform: "translateY(0%)" }))
      ]),
      transition(":leave", [
        animate("200ms ease-out", style({ transform: "translateY(100%)" }))
      ])
    ])
  ]
})
export class HomePage implements OnInit {
  isShow = false;
  searchShow = false;
  public lat = 51.678418;
  public lng = 7.809007;

  slideOpts = {
    slidesPerView: 1.5
  };

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    public menuCtrl: MenuController,
    public centerService: CenterService,
    public shopperService: ShoppersService,
    public categoriesService: CategoriesService,
    public service: ServiceService,
    public modalController: ModalController
  ) {}

  ngOnInit() {
    this.menuCtrl.enable(true);
  }

  clickSearch() {
    this.searchShow = !this.searchShow;
  }

  ionViewWillEnter() {
    this.menuCtrl.enable(true);
  }

  goToPage(path, data = null) {
    console.log(data);
    this.service.set("params", data);
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }

  istoggle() {
    this.isShow = !this.isShow;
  }
}

