import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { Products } from './../../config/services/product';
import { Order } from './../../config/services/order';
import { CartsService } from './../../config/cart.service';
import { ProductsService } from './../../config/products.service';
import { ServiceService } from './../../config/service.service';
import { map } from 'rxjs/operators';

@Component({
  selector: 'app-productdetail',
  templateUrl: './productdetail.page.html',
  styleUrls: ['./productdetail.page.scss'],
})
export class ProductdetailPage implements OnInit {
  product: Products;
  order: Order;
  data: any;
  slideOpts = {
    slidesPerView: 3.5
  };

  relatedProd = {
    slidesPerView: 2
  };

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    private cartService: CartsService,
    private prodService: ProductsService,
    private service: ServiceService
  ) {
    const params = this.prodService.selItem;
    this.service.state = true;
    this.prodService.similarProd(params.shopperId, params.category, params.subCate, params.prodId);
    this.service.get('params').then((val) => {
      this.data = val;
    });
  }

  ngOnInit() {
    console.log(this.prodService.selItem);
    const params = this.prodService.selItem;
    this.getProd(params);
  }

  getProd(params) {
    if (params) {
      const prod: Products = {
          prodId: params.prodId,
          subCate: params.subCate,
          tag: params.tag,
          prodName: params.prodName,
          prodCode: params.prodCode,
          prodDesc: params.prodDesc,
          prodStatus: params.prodStatus,
          brand: params.brand,
          category: params.category,
          shopperId: params.shopperId,
          color: params.color,
          discount: params.discount,
          featured: params.featured,
          image: params.image,
          price: params.price,
          qty: params.qty,
          shopper: params.shopper,
          skuCode: params.skuCode,
          status: params.status,
          size: params.size
      };
      this.product = prod;
    } else {
      this.product = undefined;
    }
    console.log(this.product);
  }

  stringObject(items: any) {
    items.forEach(element => {
      console.log(element.sizeId);
      element = JSON.parse(element);
      console.log(element);
    });
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.service.state = false;
    this.location.back();
  }

  buyNow(product: any, type: number) {
    this.cartService.buyNow(product).then(() => {
      if (type === 1) {
        this.router.navigateByUrl('cart');
      } else {
        // alert('Product added to cart');
      }
    });
  }

  viewProd(prod) {
    this.getProd(prod);
  }

}
