import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { MouseEvent } from '@agm/core';

@Component({
  selector: 'app-nearby',
  templateUrl: './nearby.page.html',
  styleUrls: ['./nearby.page.scss'],
})
export class NearbyPage implements OnInit {

  
  markers = [
        {
        lat: 51.67,
        lng: 7.815982,
        draggable: true
        },
        {
        lat: 51.678,
        lng: 7.827,
        draggable: false
        },
        {
        lat: 51.65,
        lng: 7.82,
        draggable: false
        
        },
        {
        lat: 51.655,
        lng: 7.86,
        draggable: false
        },
        {
        lat: 51.69,
        lng: 7.88,
        draggable: true
        }
  ];
  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location
  ) { }

 

  ngOnInit() {

}
 // google maps zoom level

  lat: number = 51.673858;
  lng: number = 7.815982;

  clickedMarker(label: string, index: number) {
    console.log(`clicked the marker: ${label || index}`)
  }
  
  mapClicked($event: MouseEvent) {
    this.markers.push({
      lat: $event.coords.lat,
      lng: $event.coords.lng,
      draggable: true
    });
  }
  
  markerDragEnd(m, $event: MouseEvent) {
    console.log('dragEnd', m, $event);
  }
  
  
  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    window.history.back();
  }
  }

  interface marker {
	lat: number;
	lng: number;
	label?: string;
	draggable: boolean;
}
