import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router, ActivatedRoute, NavigationExtras } from '@angular/router';
import { ProductsService } from './../../config/products.service';
import { ServiceService } from './../../config/service.service';

@Component({
  selector: 'app-productlist',
  templateUrl: './productlist.page.html',
  styleUrls: ['./productlist.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({ transform: 'translateY(100%)' }),
        animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
      ]),
      transition(':leave', [
        animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
      ])
    ])
  ]
})
export class ProductlistPage implements OnInit {

  onGrid = false;
  isShow = false;
  data: any;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    public prodService: ProductsService,
    public service: ServiceService
  ) {
    this.service.state = false;
    this.service.get('params').then((val) => {
      this.data = val;
      console.log(this.data);
      this.prodService.prodList(this.data.uid);
    });
  }

  ngOnInit() {}

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  istoggle() {
    this.isShow = !this.isShow;
  }

  goBack() {
    // this.location.back();
    window.history.back();
  }

  gridToggle() {
    this.onGrid = !this.onGrid;
  }

  prodDetails(index: number) {
    this.prodService.setProd(this.prodService.product[index]);
    this.router.navigateByUrl('productdetail');
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  changeFav(index) {
    const state = this.prodService.fav.findIndex(x => x === index);
    if (state > -1) {
      this.prodService.fav.splice(state, 1);
      this.prodService.changeFav(index, 'yes');
    } else {
      this.prodService.fav.push(index);
      this.prodService.changeFav(index, 'no');
    }
    console.log(this.prodService.fav);
  }

  checkFavStatus(index) {
    const state = this.prodService.fav.findIndex(x => x === index);
    console.log(state);
    return state > -1 ? true : true;
  }
}
