import { Injectable } from '@angular/core';
import { AngularFirestore, AngularFirestoreDocument, AngularFirestoreCollection } from '@angular/fire/firestore';
import { Products } from './services/product';
import { ServiceService } from './../config/service.service';

@Injectable({
  providedIn: 'root'
})
export class ProductsService {
  product: Products[] = [];
  fav: any[];
  selItem: Products;
  similar: Products[] = [];
  user: any;
  constructor(
    public afs: AngularFirestore,
    public service: ServiceService
  ) {
    this.service.get('user').then(data => {
      this.user = JSON.parse(data);
      this.getFavlist(this.user.uid);
    });
  }

  public async prodList(shopperId: string) {
    const This = this;
    const state = true;
    console.log(shopperId);
    const prodRef: AngularFirestoreCollection<any> = this.afs.collection(`products`, ref => ref.where('shopperId', '==', shopperId)
    .where('status', '==', state));
    prodRef.valueChanges().subscribe((value) => {
      this.product = [];
      const res = value;
      if (res.length > 0) {
        res.forEach((item) => {
          console.log(item.size);
          const prod: Products = {
            prodId: item.prodId,
            prodName: item.prodName,
            prodCode: item.prodCode,
            prodDesc: item.prodDesc,
            prodStatus: item.prodStatus,
            brand: item.brand,
            category: item.category,
            shopperId: item.shopperId,
            color: item.color,
            discount: item.discount,
            featured: item.featured,
            image: item.image,
            price: item.price,
            qty: item.qty,
            shopper: item.shopper,
            skuCode: item.skuCode,
            status: item.status,
            size: this.service.splitSep(item.size),
            subCate: item.subCate,
            tag: this.service.splitSep(item.tag)
          };
          this.product.push(prod);
        });
        console.log(this.product);
      } else {
        // alert('No Products Found');
      }
    });
  }


  similarProd(shopperId, category, subCate, prodId) {
    const This = this;
    const state = true;
    console.log(shopperId);
    const prodRef: AngularFirestoreCollection<any> = this.afs.collection(`products`, ref => ref.where('shopperId', '==', shopperId)
    .where('status', '==', state).where('category', '==', category).where('subCate', '==', subCate).where('prodId', '>', prodId)
    .where('prodId', '<', prodId));
    prodRef.valueChanges().subscribe((value) => {
      this.similar = [];
      const res = value;
      if (res.length > 0) {
        res.forEach((item) => {
          console.log(item.size);
          const prod: Products = {
            prodId: item.prodId,
            prodName: item.prodName,
            prodCode: item.prodCode,
            prodDesc: item.prodDesc,
            prodStatus: item.prodStatus,
            brand: item.brand,
            category: item.category,
            shopperId: item.shopperId,
            color: item.color,
            discount: item.discount,
            featured: item.featured,
            image: item.image,
            price: item.price,
            qty: item.qty,
            shopper: item.shopper,
            skuCode: item.skuCode,
            status: item.status,
            size: this.service.splitSep(item.size),
            subCate: item.subCate,
            tag: this.service.splitSep(item.tag)
          };
          this.similar.push(prod);
        });
        console.log(this.similar);
      } else {
        // alert('No Products Found');
      }
    });
  }


  public async setProd(item: Products) {
    this.selItem = item;
  }

  public async getFavlist(userId: string) {
    const favRef: AngularFirestoreDocument<any> = this.afs.collection(`favourite`).doc(userId);
    favRef.valueChanges().subscribe((value) => {
      if (Object.keys(value).length > 0) {
        this.fav = this.service.splitSep(value);
        console.log(this.fav);
      }
      console.log(value);
    });
  }

  public async changeFav(index, type) {
    console.log(index, type);
    if (type === 'yes') {
      this.afs.collection('favourite').doc(this.user.uid).update({
        [index]: true
      });
    } else {
      this.afs.collection(`favourite`).doc(this.user.uid).update({
        [index]: null
      });
    }
  }

}
