import { Component, OnInit, ViewChild } from '@angular/core';
import { IonSlides } from '@ionic/angular';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';


@Component({
  selector: 'app-cart',
  templateUrl: './cart.page.html',
  styleUrls: ['./cart.page.scss'],
})
export class CartPage implements OnInit {

  @ViewChild(IonSlides, { static: false }) slides: IonSlides;
  currentIndex: any;
  count:any;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location
  ) { 

    this.currentIndex = 0;
    this.count = 0;
  }

  ngOnInit() {
  }

 
  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }  
  
  cart_wizard = {
    initialSlide: 0,
    speed: 1000,
    allowTouchMove: false
  };


  next() {
    this.slides.slideNext();
  }

  prev() {
    this.slides.slidePrev();
  }

  addCount(){
    this.count = this.count+1
  }

  removeCount() {
    this.count = this.count - 1;
    if(this.count <0){
      this.count = 0;
    }
  }


  slideChanged() {
    this.slides.getActiveIndex().then(index => {
      this.currentIndex = index;
      console.log(this.currentIndex);

    });
  } 

}
