
import { Component, OnInit, ViewChild, ElementRef } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';

declare var google;

@Component({
  selector: 'app-trackorder',
  templateUrl: './trackorder.page.html',
  styleUrls: ['./trackorder.page.scss'],
})
export class TrackorderPage implements OnInit {

  map: any;
  address: string

  public lat: number = 51.678418;
  public lng: number = 7.809007;
  public origin: any;
  public destination: any;
  public renderOptions: any;
  public markerOptions: any;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location
  ) { }

  
  ngOnInit() {
    this.getDirection();
  }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    window.history.back();
  }




  getDirection() {
    this.origin = { lat: 51.678418, lng: 7.809007 };
    this.destination = { lat: 51.678418, lng: 7.81900 };
    this.renderOptions = { polylineOptions: { strokeColor: 'rgba(69, 67, 152,1)' }, suppressMarkers: true };
    this.markerOptions = {
      origin: {
        icon: './assets/source.png',
      },
      destination: {
        icon: './assets/destination.png',
      }
    };
  }

}
