import * as tslib_1 from "tslib";
import { Location } from '@angular/common';
import { Component } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { NativeGeocoder } from '@ionic-native/native-geocoder/ngx';
import { Geolocation } from '@ionic-native/geolocation/ngx';
import { AuthService } from './../../config/auth.service';
let AddaddresssPage = class AddaddresssPage {
    constructor(router, route, location, geolocation, nativeGeocoder, register) {
        this.router = router;
        this.route = route;
        this.location = location;
        this.geolocation = geolocation;
        this.nativeGeocoder = nativeGeocoder;
        this.register = register;
        this.address = {
            addressType: '',
            area: '',
            city: '',
            country: '',
            district: '',
            firstAddress: '',
            landmark: '',
            zip: '',
            secondAddress: '',
            state: '',
            default: 0
        };
        this.submitted = false;
        this.geoencoderOptions = {
            useLocale: true,
            maxResults: 5
        };
    }
    ngOnInit() {
    }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        this.location.back();
    }
    getGeolocation() {
        console.log('getLocation');
        this.geolocation.getCurrentPosition().then(pos => {
            console.log('get New location');
            console.log(pos);
            this.geoLatitude = pos.coords.latitude;
            this.geoLongitude = pos.coords.longitude;
            this.geoAccuracy = pos.coords.accuracy;
            this.getGeoencoder(this.geoLatitude, this.geoLongitude);
        }).catch(err => {
            alert('Error getting location' + JSON.stringify(err));
        });
    }
    getGeoencoder(latitude, longitude) {
        console.log('reached');
        this.nativeGeocoder.reverseGeocode(latitude, longitude, this.geoencoderOptions)
            .then((result) => {
            console.log(result);
            this.geoAddress = this.generateAddress(result[0]);
            console.log(this.geoAddress);
        })
            .catch((error) => {
            alert('Error getting location' + JSON.stringify(error));
        });
    }
    generateAddress(addressObj) {
        const obj = [];
        let address = '';
        // tslint:disable-next-line:forin
        for (const key in addressObj) {
            obj.push(addressObj[key]);
        }
        obj.reverse();
        for (const val in obj) {
            if (obj[val].length) {
                address += obj[val] + ', ';
            }
        }
        return address.slice(0, -2);
    }
    onAddrss(form) {
        this.submitted = true;
        console.log(form.value);
        if (form.valid) {
            console.log(form.value);
            this.register.createAddress(form.value);
        }
        else {
            console.log(form.errors);
        }
    }
};
AddaddresssPage = tslib_1.__decorate([
    Component({
        selector: 'app-addaddresss',
        templateUrl: './addaddresss.page.html',
        styleUrls: ['./addaddresss.page.scss'],
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        ActivatedRoute,
        Location,
        Geolocation,
        NativeGeocoder,
        AuthService])
], AddaddresssPage);
export { AddaddresssPage };
//# sourceMappingURL=addaddresss.page.js.map