import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Router } from '@angular/router';
import { Location } from '@angular/common';
import { ServiceService } from './../../config/service.service';
import { ShoppersService } from './../../config/shopper.service';
import { SearchService } from '../../config/search.service';
import { trigger, transition, animate, style } from '@angular/animations';
import { ModalController } from '@ionic/angular';
import { SearchmodalPage } from '../searchmodal/searchmodal.page';
import { SubjectService } from './../../config/subject.service';
let CatStorelistPage = class CatStorelistPage {
    constructor(router, location, service, shopperService, searchService, modalController, subjectService) {
        this.router = router;
        this.location = location;
        this.service = service;
        this.shopperService = shopperService;
        this.searchService = searchService;
        this.modalController = modalController;
        this.subjectService = subjectService;
        this.searchShow = false;
        this.slideOpts = {
            slidesPerView: 1.5
        };
        this.service.get('catParams').then(val => {
            this.data = val;
            if (this.data.catId === '0') {
                this.shopperService.shopperList(true, 'status');
            }
            else {
                console.log('error');
                this.shopperService.shopperList(this.data.catId, 'catId');
            }
        });
    }
    clickSearch() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.subjectService.setTabData(false);
            const modal = yield this.modalController.create({
                component: SearchmodalPage
            });
            modal.onDidDismiss().then(dataReturned => {
                this.subjectService.setTabData(true);
            });
            return yield modal.present();
        });
    }
    searchClose() {
        this.searchShow = false;
    }
    ngOnInit() { }
    goToPage(path, data = null) {
        this.service.set('shopParams', data);
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        this.location.back();
    }
};
CatStorelistPage = tslib_1.__decorate([
    Component({
        selector: 'app-catstorelist',
        templateUrl: './catstorelist.page.html',
        styleUrls: ['./catstorelist.page.scss'],
        animations: [
            trigger('slideInOut', [
                transition(':enter', [
                    style({ transform: 'translateY(100%)' }),
                    animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
                ]),
                transition(':leave', [
                    animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
                ])
            ])
        ]
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        Location,
        ServiceService,
        ShoppersService,
        SearchService,
        ModalController,
        SubjectService])
], CatStorelistPage);
export { CatStorelistPage };
//# sourceMappingURL=catstorelist.page.js.map