import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { UpdateService } from '../../config/update.service';
import { ServiceService } from '../../config/service.service';
let ChangedetailsPage = class ChangedetailsPage {
    constructor(router, route, location, register, service) {
        this.router = router;
        this.route = route;
        this.location = location;
        this.register = register;
        this.service = service;
        this.updateData = {
            phoneVerified: false,
            phone: ''
        };
        this.updatePassword = {
            password: '',
            confirmPassword: ''
        };
        this.submitted = false;
        // Gets userdata
        this.service.get('userData').then(val => {
            console.log(JSON.parse(val));
            this.userData = JSON.parse(val);
            console.log(this.userData);
        });
        // this.service.get('user').then(data => {
        //   if (data) {
        //     this.userData = JSON.parse(data);
        //     console.log(this.userData);
        //   }
        // });
    }
    ngOnInit() { }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        this.location.back();
    }
    onFormSubmit(form) {
        this.submitted = true;
        console.log(form.value);
        // if (form.valid) {
        // Change Password
        if (form.value.currentPassword &&
            form.value.password &&
            form.value.password === form.value.confirmPassword) {
            this.register.updateData(form.value, this.userData.uid);
            this.register.updatePassword(form.value.currentPassword, form.value.password);
        }
        else {
            this.register.updateData(form.value, this.userData);
            console.log('profile updated', form.value);
        }
    }
};
ChangedetailsPage = tslib_1.__decorate([
    Component({
        selector: 'app-changedetails',
        templateUrl: './changedetails.page.html',
        styleUrls: ['./changedetails.page.scss']
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        ActivatedRoute,
        Location,
        UpdateService,
        ServiceService])
], ChangedetailsPage);
export { ChangedetailsPage };
//# sourceMappingURL=changedetails.page.js.map