import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { ModalController, NavParams } from '@ionic/angular';
import { OrdersService } from './../../config/order.service';
let DeliverypopPage = class DeliverypopPage {
    constructor(modalController, navParams, orderService) {
        this.modalController = modalController;
        this.navParams = navParams;
        this.orderService = orderService;
        this.currDate = new Date();
    }
    ngOnInit() {
        this.params = this.navParams.data;
        console.log(this.navParams.data);
    }
    closeModal() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const onClosedData = 'Wrapped Up!';
            yield this.modalController.dismiss(onClosedData);
        });
    }
    changeOrder(status) {
        this.orderId = this.params.orderId;
        this.orderService.changeOrder(this.orderId, status).then(() => {
            this.closeModal();
        });
    }
};
DeliverypopPage = tslib_1.__decorate([
    Component({
        selector: 'app-deliverypop',
        templateUrl: './deliverypop.page.html',
        styleUrls: ['./deliverypop.page.scss'],
    }),
    tslib_1.__metadata("design:paramtypes", [ModalController,
        NavParams,
        OrdersService])
], DeliverypopPage);
export { DeliverypopPage };
//# sourceMappingURL=deliverypop.page.js.map