import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Location } from '@angular/common';
import { SubjectService } from '../../config/subject.service';
import { FeedbackService } from '../../config/feedback.service';
import { ServiceService } from '../../config/service.service';
let FeedbackPage = class FeedbackPage {
    constructor(location, subjectService, feedService, service) {
        this.location = location;
        this.subjectService = subjectService;
        this.feedService = feedService;
        this.service = service;
        this.submitted = false;
        this.feedbackData = {
            feedbackId: '',
            from: '',
            to: 'care@getmi.com',
            message: ''
        };
        // Gets userdata
        this.subjectService.getUserData().subscribe(userData => {
            if (userData) {
                this.userData = JSON.parse(userData);
                console.log(userData);
            }
            else {
                console.log(userData);
            }
        });
    }
    onFeedbackSubmit(form) {
        this.submitted = true;
        console.log(form.value);
        if (form.valid && form.value.message !== '') {
            this.feedService.feedbackCreate(form.value);
        }
        else {
            this.submitted = false;
            this.service.showToast('Invalid request!', 'top', 'my-error', 1000);
        }
    }
    ngOnInit() { }
    goBack() {
        this.location.back();
    }
};
FeedbackPage = tslib_1.__decorate([
    Component({
        selector: 'app-feedback',
        templateUrl: './feedback.page.html',
        styleUrls: ['./feedback.page.scss']
    }),
    tslib_1.__metadata("design:paramtypes", [Location,
        SubjectService,
        FeedbackService,
        ServiceService])
], FeedbackPage);
export { FeedbackPage };
//# sourceMappingURL=feedback.page.js.map