import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router, ActivatedRoute } from '@angular/router';
import { ProductsService } from './../../config/products.service';
import { ServiceService } from './../../config/service.service';
import { SearchService } from './../../config/search.service';
import { ModalController } from '@ionic/angular';
import { SearchmodalPage } from '../searchmodal/searchmodal.page';
import { SubjectService } from './../../config/subject.service';
let ProductlistPage = class ProductlistPage {
    constructor(router, route, location, prodService, service, searchService, modalController, subjectService) {
        this.router = router;
        this.route = route;
        this.location = location;
        this.prodService = prodService;
        this.service = service;
        this.searchService = searchService;
        this.modalController = modalController;
        this.subjectService = subjectService;
        this.onGrid = false;
        this.isShow = false;
        this.searchShow = false;
        this.loader = true;
        const users = this.service.get('user').then(data => {
            if (data) {
                data = JSON.parse(data);
                this.custId = data.uid;
            }
        });
    }
    ngOnInit() { }
    ionViewWillEnter() {
        console.log('logged');
        this.service.get('shopParams').then(val => {
            if (val) {
                this.data = val;
                this.shopperId = this.data.uid;
                console.log(this.data);
                this.prodService.prodList(this.data.uid);
                setTimeout(() => {
                    this.loader = false;
                }, 2000);
            }
            else {
                this.goToPage('home');
            }
        });
        const users = this.service.get('user').then(data => {
            if (data) {
                data = JSON.parse(data);
                this.prodService.getFavlist(data.uid);
            }
        });
    }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    istoggle() {
        this.isShow = !this.isShow;
    }
    goBack() {
        // this.location.back();
        window.history.back();
    }
    unEscape(text) {
        const regex = '%uFFFD';
        return unescape(text.replace(/%uFFFD/g, ''));
    }
    gridToggle() {
        this.onGrid = !this.onGrid;
    }
    clickSearch() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.subjectService.setTabData(false);
            const modal = yield this.modalController.create({
                component: SearchmodalPage
            });
            modal.onDidDismiss().then(dataReturned => {
                this.subjectService.setTabData(true);
            });
            return yield modal.present();
        });
    }
    searchClose() {
        this.searchShow = false;
    }
    prodDetails(index) {
        this.prodService.setProd(this.prodService.product[index]);
        this.router.navigateByUrl('productdetail');
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    changeFav(index) {
        const state = this.prodService.fav.findIndex(x => x === index);
        console.log(state);
        console.log(this.prodService.fav);
        if (state > -1) {
            this.prodService.fav.splice(state, 1);
            this.prodService.changeFav(index, 'yes');
        }
        else {
            this.prodService.fav.push(index);
            this.prodService.changeFav(index, 'no');
        }
        return;
        console.log(this.prodService.fav);
    }
    setValue(value) {
        this.sortValue = value;
        console.log(this.sortValue);
    }
    submit() {
        console.log(this.sortValue);
        this.prodService.filterSearch(this.sortValue, this.shopperId);
    }
    checkFavStatus(index) {
        const state = this.prodService.fav.findIndex(x => x === index);
        return state > -1 ? 'fav_fill' : 'fav_icon';
    }
    searchFun(data) {
        this.searchService.search(data);
    }
    viewPage(datas) {
        console.log(datas);
        let data;
        let url;
        if (datas.type === 'shopper') {
            data = datas.data;
            this.service.set('shopParams', data);
            url = 'productlist';
        }
        else if (datas.type === 'category') {
            data = datas.data;
            this.service.set('catParams', data);
            url = 'catstorelist';
        }
        else {
            data = datas.data;
            data.size = this.service.splitSep(data.size);
            data.tag = this.service.splitSep(data.tag);
            (data.color = this.service.splitSep(data.color)), (url = 'productdetail');
            this.prodService.setProd(data);
        }
        this.searchClose();
        this.router.navigateByUrl(url, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
};
ProductlistPage = tslib_1.__decorate([
    Component({
        selector: 'app-productlist',
        templateUrl: './productlist.page.html',
        styleUrls: ['./productlist.page.scss'],
        animations: [
            trigger('slideInOut', [
                transition(':enter', [
                    style({ transform: 'translateY(100%)' }),
                    animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
                ]),
                transition(':leave', [
                    animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
                ])
            ])
        ]
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        ActivatedRoute,
        Location,
        ProductsService,
        ServiceService,
        SearchService,
        ModalController,
        SubjectService])
], ProductlistPage);
export { ProductlistPage };
//# sourceMappingURL=productlist.page.js.map