import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { UserService } from '../../config/user.service';
import { ServiceService } from '../../config/service.service';
import { AuthService } from '../../config/auth.service';
import { SubjectService } from './../../config/subject.service';
import { Router, ActivatedRoute } from '@angular/router';
import { finalize } from 'rxjs/operators';
import { Location } from '@angular/common';
import { AddressService } from './../../config/address.service';
import { WishService } from './../../config/wish.service';
import { AngularFireStorage } from '@angular/fire/storage';
import { trigger, transition, animate, style } from '@angular/animations';
let ProfilePage = class ProfilePage {
    constructor(route, router, storage, useService, service, authService, addressService, wishService, location, subject) {
        this.route = route;
        this.router = router;
        this.storage = storage;
        this.useService = useService;
        this.service = service;
        this.authService = authService;
        this.addressService = addressService;
        this.wishService = wishService;
        this.location = location;
        this.subject = subject;
        this.isShow = false;
        this.loader = false;
        this.service.get('user').then(data => {
            if (data) {
                this.userData = JSON.parse(data);
                this.wishService.wishList(this.userData.uid);
                console.log(this.userData);
            }
        });
        // Listens to url
        route.params.subscribe(val => {
            // Get user Data
            this.service.get('userData').then(data => {
                if (data) {
                    this.loggedUser = JSON.parse(data);
                }
            });
        });
    }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    ionViewWillEnter() {
        this.authService.checkLogin();
    }
    ngOnInit() {
        console.log('profile page');
        const This = this;
        setTimeout(() => {
            this.user = this.useService.users;
            // console.log('[users]', this.user);
            this.service.set('params', this.user);
        }, 500);
    }
    istoggle() {
        this.isShow = !this.isShow;
    }
    goBack() {
        this.location.back();
    }
    fileChange(event) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.loader = true;
            const fileList = event.target.files;
            if (fileList.length > 0) {
                const reader = new FileReader();
                let profilePic;
                reader.onload = (events) => {
                    profilePic = events.target.result;
                    this.loggedUser.profilePhoto = events.target.result;
                };
                profilePic = event.target.result;
                reader.readAsDataURL(event.target.files[0]);
                const file = fileList[0];
                const ext = file.name.split('.').pop();
                if (ext === 'jpg' || ext === 'jpeg' || ext === 'png') {
                    const path = file.name; // + Date.now();
                    const ref = this.storage.ref(path);
                    const task = this.storage
                        .upload(path, file)
                        .snapshotChanges()
                        .pipe(finalize(() => {
                        ref.getDownloadURL().subscribe(url => {
                            this.loader = false;
                            this.authService.profilePic(url);
                            this.service.get('userData').then(userData => {
                                const userDatas = JSON.parse(userData);
                                userDatas.profilePhoto = url;
                                this.service.set('userData', JSON.stringify(userDatas));
                                this.subject.sendUserData(JSON.stringify(userDatas));
                            });
                        });
                    }))
                        .subscribe();
                    // this.downloadURL = await ref.getDownloadURL().toPromise();
                    // console.log(this.downloadURL);
                }
            }
        });
    }
};
ProfilePage = tslib_1.__decorate([
    Component({
        selector: 'app-profile',
        templateUrl: './profile.page.html',
        styleUrls: ['./profile.page.scss'],
        animations: [
            trigger('slideInOut', [
                transition(':enter', [
                    style({ transform: 'translateY(100%)' }),
                    animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
                ]),
                transition(':leave', [
                    animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
                ])
            ])
        ]
    }),
    tslib_1.__metadata("design:paramtypes", [ActivatedRoute,
        Router,
        AngularFireStorage,
        UserService,
        ServiceService,
        AuthService,
        AddressService,
        WishService,
        Location,
        SubjectService])
], ProfilePage);
export { ProfilePage };
//# sourceMappingURL=profile.page.js.map