import * as tslib_1 from "tslib";
import { Location } from '@angular/common';
import { Component, ElementRef, ViewChild } from '@angular/core';
import { Router } from '@angular/router';
import { ModalController } from '@ionic/angular';
import { ProductsService } from './../../config/products.service';
import { SearchService } from './../../config/search.service';
import { ServiceService } from './../../config/service.service';
let SearchmodalPage = class SearchmodalPage {
    constructor(modalController, searchService, service, productsService, router, location) {
        this.modalController = modalController;
        this.searchService = searchService;
        this.service = service;
        this.productsService = productsService;
        this.router = router;
        this.location = location;
        this.searchShow = false;
    }
    ngOnInit() {
        this.searchService.searchList = [];
    }
    ionViewWillEnter() {
        this.searchText.nativeElement.focus();
    }
    closeModal() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            /* await this.modalController.dismiss(); */
            this.location.back();
        });
    }
    searchFun(data) {
        this.searchShow = true;
        this.searchService.search(data);
    }
    clickSearch() {
        this.searchShow = true;
        this.searchService.searchList = [];
    }
    viewPage(datas) {
        // this.closeModal();
        console.log(datas);
        let data;
        let url;
        if (datas.type === 'shopper') {
            data = datas.data;
            this.service.set('shopParams', data);
            url = 'productlist';
        }
        else if (datas.type === 'category') {
            data = datas.data;
            this.service.set('catParams', data);
            url = 'catstorelist';
        }
        else {
            data = datas.data;
            data.size = this.service.splitSep(data.size);
            data.tag = this.service.splitSep(data.tag);
            (data.color = this.service.splitSep(data.color)), (url = 'productdetail');
            this.productsService.setProd(data);
        }
        console.log('here');
        this.searchClose();
        this.router.navigateByUrl(url, { queryParams: data, replaceUrl: true });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    searchClose() {
        // this.closeModal();
        this.searchShow = false;
    }
    unEscape(text) {
        const respVal = unescape(text);
        return respVal.replace('�', '');
    }
};
tslib_1.__decorate([
    ViewChild('searchText', { static: false }),
    tslib_1.__metadata("design:type", ElementRef)
], SearchmodalPage.prototype, "searchText", void 0);
SearchmodalPage = tslib_1.__decorate([
    Component({
        selector: 'app-searchmodal',
        templateUrl: './searchmodal.page.html',
        styleUrls: ['./searchmodal.page.scss']
    }),
    tslib_1.__metadata("design:paramtypes", [ModalController,
        SearchService,
        ServiceService,
        ProductsService,
        Router,
        Location])
], SearchmodalPage);
export { SearchmodalPage };
//# sourceMappingURL=searchmodal.page.js.map