import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { MyordersService } from './../../config/myorder.service';
let TrackorderPage = class TrackorderPage {
    constructor(router, route, location, myorder) {
        this.router = router;
        this.route = route;
        this.location = location;
        this.myorder = myorder;
        this.lat = 51.678418;
        this.lng = 7.809007;
    }
    ngOnInit() {
        this.getDirection();
    }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        window.history.back();
    }
    getDirection() {
        this.order = this.myorder.selItem;
        this.origin = { lat: this.order.pickupLocation._lat, lng: this.order.pickupLocation._long };
        this.destination = { lat: this.order.deliveryLocation._lat, lng: this.order.deliveryLocation._long };
        this.renderOptions = { polylineOptions: { strokeColor: 'rgba(69, 67, 152,1)' }, suppressMarkers: true };
        this.markerOptions = {
            origin: {
                icon: './assets/source.png',
            },
            destination: {
                icon: './assets/destination.png',
            }
        };
    }
};
TrackorderPage = tslib_1.__decorate([
    Component({
        selector: 'app-trackorder',
        templateUrl: './trackorder.page.html',
        styleUrls: ['./trackorder.page.scss'],
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        ActivatedRoute,
        Location,
        MyordersService])
], TrackorderPage);
export { TrackorderPage };
//# sourceMappingURL=trackorder.page.js.map