import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { AngularFirestore } from '@angular/fire/firestore';
import { take } from 'rxjs/operators';
import { ServiceService } from './../config/service.service';
let ProductsService = class ProductsService {
    constructor(afs, service) {
        this.afs = afs;
        this.service = service;
        this.product = [];
        this.similar = [];
        this.product = [];
        this.fav = [];
        this.prodSlideImg = [];
        this.service.get('user').then(data => {
            this.user = JSON.parse(data);
            this.getFavlist(this.user.uid);
        });
    }
    // Fetches images for slide
    fetchGallery(skuID) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            // firebase query
            return new Promise(resolve => {
                const prodRef = this.afs.collection(`product_gallery`, ref => ref.where('skuId', '==', skuID));
                prodRef.valueChanges().subscribe(value => {
                    this.prodSlideImg = [];
                    const res = value;
                    if (res.length > 0) {
                        res.forEach(item => {
                            this.prodSlideImg.push(item.downloadURL);
                        });
                        resolve(this.prodSlideImg);
                    }
                    else {
                        resolve(this.prodSlideImg);
                    }
                });
            });
        });
    }
    prodList(shopperId) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            // console.log(shopperId);
            const prodRef = this.afs.collection(`products`, ref => ref
                .orderBy('category', 'asc')
                .where('shopperId', '==', shopperId)
                .where('status', '==', state));
            prodRef.valueChanges().subscribe(value => {
                this.product = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item.size);
                        const prod = {
                            prodId: item.prodId,
                            prodName: item.prodName,
                            prodCode: item.prodCode,
                            prodDesc: item.prodDesc,
                            prodStatus: item.prodStatus,
                            brand: item.brand,
                            category: item.category,
                            shopperId: item.shopperId,
                            color: this.service.splitSep(item.color),
                            discount: item.discount,
                            featured: item.featured,
                            image: item.image,
                            price: item.price,
                            qty: item.qty,
                            shopper: item.shopper,
                            skuCode: item.skuCode,
                            status: item.status,
                            rating: item.rating,
                            centerId: item.centerId,
                            centerRef: item.center,
                            size: this.service.splitSep(item.size),
                            subCate: item.subCate,
                            tag: this.service.splitSep(item.tag)
                        };
                        this.product.push(prod);
                    });
                    // console.log(this.product);
                }
                else {
                    // alert('No Products Found');
                }
            });
        });
    }
    filterSearch(sortValue, shopperId) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            // console.log(sortValue);
            let field, order;
            if (sortValue === 'low') {
                field = 'price';
                order = 'asc';
            }
            if (sortValue === 'high') {
                field = 'price';
                order = 'desc';
            }
            if (sortValue === 'a-z') {
                field = 'prodName';
                order = 'asc';
            }
            if (sortValue === 'newest') {
                field = 'createdAt';
                order = 'asc';
            }
            // tslint:disable-next-line:max-line-length
            const prodRef = this.afs.collection(`products`, ref => ref
                .where('status', '==', state)
                .where('shopperId', '==', shopperId)
                .orderBy(field, order));
            prodRef.valueChanges().subscribe(value => {
                this.product = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item.size);
                        const prod = {
                            prodId: item.prodId,
                            prodName: item.prodName,
                            prodCode: item.prodCode,
                            prodDesc: item.prodDesc,
                            prodStatus: item.prodStatus,
                            brand: item.brand,
                            category: item.category,
                            shopperId: item.shopperId,
                            color: this.service.splitSep(item.color),
                            discount: item.discount,
                            featured: item.featured,
                            image: item.image,
                            price: item.price,
                            qty: item.qty,
                            rating: item.rating,
                            shopper: item.shopper,
                            skuCode: item.skuCode,
                            centerId: item.centerId,
                            centerRef: item.center,
                            status: item.status,
                            size: this.service.splitSep(item.size),
                            subCate: item.subCate,
                            tag: this.service.splitSep(item.tag)
                        };
                        this.product.push(prod);
                    });
                    // console.log(this.product);
                }
                else {
                    // alert('No Products Found');
                }
            });
        });
    }
    similarProd(shopperId, category, subCate, prodId) {
        const This = this;
        const state = true;
        // console.log(shopperId);
        const prodRef = this.afs.collection(`products`, ref => ref
            .where('shopperId', '==', shopperId)
            .where('status', '==', state)
            .where('category', '==', category)
            .where('subCate', '==', subCate)
            .where('prodId', '>', prodId)
            .where('prodId', '<', prodId));
        prodRef.valueChanges().subscribe(value => {
            this.similar = [];
            const res = value;
            if (res.length > 0) {
                res.forEach(item => {
                    // console.log(item.size);
                    const prod = {
                        prodId: item.prodId,
                        prodName: item.prodName,
                        prodCode: item.prodCode,
                        prodDesc: item.prodDesc,
                        prodStatus: item.prodStatus,
                        brand: item.brand,
                        category: item.category,
                        shopperId: item.shopperId,
                        color: item.color,
                        discount: item.discount,
                        featured: item.featured,
                        image: item.image,
                        price: item.price,
                        qty: item.qty,
                        shopper: item.shopper,
                        rating: item.rating,
                        skuCode: item.skuCode,
                        centerId: item.centerId,
                        centerRef: item.center,
                        status: item.status,
                        size: this.service.splitSep(item.size),
                        subCate: item.subCate,
                        tag: this.service.splitSep(item.tag)
                    };
                    this.similar.push(prod);
                });
                // console.log(this.similar);
            }
            else {
                // alert('No Products Found');
            }
        });
    }
    setProd(item) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.selItem = item;
        });
    }
    getFavlist(userId) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            console.log(userId);
            const favRef = this.afs
                .collection(`favourite`)
                .doc(userId);
            favRef
                .valueChanges()
                .pipe(take(1) // Here you can limit to only emit once, using the take operator
            )
                .subscribe(value => {
                if (value !== undefined) {
                    if (Object.keys(value).length > 0) {
                        this.fav = this.service.splitSep(value);
                        console.log(this.fav);
                    }
                    // console.log(value);
                }
                else {
                    this.fav = [];
                }
            });
        });
    }
    changeFav(index, type) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            // console.log(index, type, this.user.uid);
            if (type === 'no') {
                this.afs
                    .collection('favourite')
                    .doc(this.user.uid)
                    .valueChanges()
                    .pipe(take(1) // Here you can limit to only emit once, using the take operator
                )
                    .subscribe(value => {
                    if (value === undefined) {
                        this.afs
                            .collection('favourite')
                            .doc(this.user.uid)
                            .set({
                            [index]: true
                        });
                    }
                    else {
                        // console.log(value);
                        value[index] = true;
                        // console.log(value);
                        this.afs
                            .collection('favourite')
                            .doc(this.user.uid)
                            .set(value);
                    }
                });
            }
            else {
                this.afs
                    .collection('favourite')
                    .doc(this.user.uid)
                    .valueChanges()
                    .pipe(take(1) // Here you can limit to only emit once, using the take operator
                )
                    .subscribe(value => {
                    // console.log(value);
                    if (value !== undefined) {
                        value[index] = undefined;
                        Object.keys(value).forEach(key => value[key] === undefined ? delete value[key] : '');
                        // console.log(value);
                        this.afs
                            .collection('favourite')
                            .doc(this.user.uid)
                            .set(value);
                    }
                    else {
                        // console.log(value);
                    }
                });
            }
        });
    }
};
ProductsService = tslib_1.__decorate([
    Injectable({
        providedIn: 'root'
    }),
    tslib_1.__metadata("design:paramtypes", [AngularFirestore, ServiceService])
], ProductsService);
export { ProductsService };
//# sourceMappingURL=products.service.js.map