import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { AngularFireAuth } from '@angular/fire/auth';
import { AngularFirestore } from '@angular/fire/firestore';
import * as firebase from 'firebase';
let ShoppersService = class ShoppersService {
    constructor(afs, afAuth) {
        this.afs = afs;
        this.afAuth = afAuth;
        this.shoppers = [];
        this.activeshoppers = [];
        this.nearshoppers = [];
        this.featuredshopperList();
        this.getNearBy(10.0159, 76.3419, 10);
    }
    shopperList(centerId, type) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            const orderRef = this.afs.collection('shoppers', ref => ref.where(type, '==', centerId).where('status', '==', state).orderBy('name', 'asc'));
            orderRef.valueChanges().subscribe(value => {
                this.shoppers = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item);
                        const shopper = {
                            name: item.name,
                            emailId: item.emailId,
                            phone: item.phone,
                            uid: item.uid,
                            profilePhoto: item.profilePic,
                            status: item.status,
                            address: item.address,
                            featured: item.featured,
                            featuredImage: item.featuredImage,
                            shopName: item.shopName,
                            shopStatus: item.shopStatus,
                            workingHours: item.workingHours,
                            caption: item.caption,
                            centre: item.centre,
                            location: item.location,
                            rate: item.rate,
                            centerId: item.centerId
                        };
                        this.shoppers.push(shopper);
                    });
                    // console.log(this.shoppers);
                }
                else {
                    // alert('No Orders Found');
                }
            });
        });
    }
    featuredshopperList() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            const orderRef = this.afs.collection('shoppers', ref => ref.where('featured', '==', state).where('status', '==', state).orderBy('name', 'asc'));
            orderRef.valueChanges().subscribe(value => {
                this.activeshoppers = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item);
                        const shopper = {
                            name: item.name,
                            emailId: item.emailId,
                            phone: item.phone,
                            uid: item.uid,
                            profilePhoto: item.profilePic,
                            status: item.status,
                            address: item.address,
                            featured: item.featured,
                            featuredImage: item.featuredImage,
                            shopName: item.shopName,
                            shopStatus: item.shopStatus,
                            workingHours: item.workingHours,
                            caption: item.caption,
                            centre: item.centre,
                            location: item.location,
                            rate: item.rate,
                            centerId: item.centerId
                        };
                        this.activeshoppers.push(shopper);
                    });
                    // console.log(this.activeshoppers);
                }
                else {
                    // alert('No Orders Found');
                }
            });
        });
    }
    getNearBy(latitude, longitude, distance) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            const lat = 0.0144927536231884;
            const lon = 0.0181818181818182;
            const lowerLat = latitude - lat * distance;
            const lowerLon = longitude - lon * distance;
            const greaterLat = latitude + lat * distance;
            const greaterLon = longitude + lon * distance;
            const lesserGeopoint = new firebase.firestore.GeoPoint(lowerLat, lowerLon);
            const greaterGeopoint = new firebase.firestore.GeoPoint(greaterLat, greaterLon);
            const orderRef = this.afs.collection('shoppers', ref => ref
                .where('centre.latLng', '>', lesserGeopoint)
                .where('centre.latLng', '<', greaterGeopoint)
                .where('status', '==', state));
            orderRef.valueChanges().subscribe(value => {
                this.nearshoppers = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item);
                        const shopper = {
                            name: item.name,
                            emailId: item.emailId,
                            phone: item.phone,
                            uid: item.uid,
                            profilePhoto: item.profilePic,
                            status: item.status,
                            address: item.address,
                            featured: item.featured,
                            featuredImage: item.featuredImage,
                            shopName: item.shopName,
                            shopStatus: item.shopStatus,
                            workingHours: item.workingHours,
                            caption: item.caption,
                            centre: item.centre,
                            location: item.location,
                            rate: item.rate,
                            centerId: item.centerId
                        };
                        this.nearshoppers.push(shopper);
                    });
                    // console.log(this.nearshoppers);
                }
                else {
                    // alert('No Orders Found');
                }
            });
        });
    }
};
ShoppersService = tslib_1.__decorate([
    Injectable({
        providedIn: 'root'
    }),
    tslib_1.__metadata("design:paramtypes", [AngularFirestore, AngularFireAuth])
], ShoppersService);
export { ShoppersService };
//# sourceMappingURL=shopper.service.js.map